/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.transmitter;

import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.item.block.transmitter.ItemBlockTransporter;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ItemBlockLogisticalTransporter
extends ItemBlockTransporter<TileEntityLogisticalTransporter> {
    public ItemBlockLogisticalTransporter(BlockLargeTransmitter<TileEntityLogisticalTransporter> block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    @NotNull
    public TransporterTier getTier() {
        return Attribute.getTier(this.getBlock(), TransporterTier.class);
    }

    @Override
    protected void addStats(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.addStats(stack, context, tooltip, flag);
        TransporterTier tier = this.getTier();
        float tickRate = Math.max(context.tickRate(), 1.0f);
        float speed = (float)tier.getSpeed() / (100.0f / tickRate);
        float pull = (float)tier.getPullAmount() * tickRate / 10.0f;
        tooltip.add((Component)MekanismLang.SPEED.translateColored(EnumColor.INDIGO, EnumColor.GRAY, UnitDisplayUtils.roundDecimals(speed)));
        tooltip.add((Component)MekanismLang.PUMP_RATE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, UnitDisplayUtils.roundDecimals(pull)));
    }
}

