/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mekanism.api.security.SecurityMode;
import mekanism.common.Mekanism;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.lib.CustomObjectToObjectArrayMap;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityUtils;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileComponentFrequency
implements ITileComponent {
    private static final AtomicInteger OFFSET = new AtomicInteger(0);
    private final TileEntityMekanism tile;
    private final CustomObjectToObjectArrayMap<FrequencyType<?>, FrequencyData> nonSecurityFrequencies = new CustomObjectToObjectArrayMap();
    @Nullable
    private FrequencyData securityFrequency = null;
    private final Map<SecurityMode, Map<FrequencyType<?>, List<? extends Frequency>>> frequencyCache = new EnumMap(SecurityMode.class);
    private final int tickOffset;
    private boolean needsSave;
    private boolean needsNotify;
    private final BiConsumer<FrequencyType<?>, FrequencyData> updateFrequencyRef = this::updateFrequency;

    public TileComponentFrequency(TileEntityMekanism tile) {
        this.tile = tile;
        this.tickOffset = OFFSET.getAndIncrement() % 5;
        tile.addComponent(this);
    }

    public boolean hasCustomFrequencies() {
        return !this.nonSecurityFrequencies.isEmpty();
    }

    public Set<FrequencyType<?>> getCustomFrequencies() {
        return this.nonSecurityFrequencies.keySet();
    }

    public void tickServer(Level level, BlockPos pos) {
        if (level.getGameTime() % 5L == (long)this.tickOffset) {
            if (this.securityFrequency != null) {
                this.updateFrequency(FrequencyType.SECURITY, this.securityFrequency);
            }
            this.nonSecurityFrequencies.forEach(this.updateFrequencyRef);
        }
        if (this.needsNotify) {
            this.tile.invalidateCapabilitiesFull();
            WorldUtils.notifyLoadedNeighborsOfTileChange(level, pos);
            this.needsNotify = false;
        }
        if (this.needsSave) {
            this.tile.setChanged();
            this.needsSave = false;
        }
    }

    public void track(FrequencyType<?> type, boolean needsSync, boolean needsListCache, boolean notifyNeighbors) {
        FrequencyData value = new FrequencyData(needsSync, needsListCache, notifyNeighbors);
        if (type == FrequencyType.SECURITY) {
            this.securityFrequency = value;
        } else {
            this.nonSecurityFrequencies.put(type, value);
        }
    }

    @Nullable
    public <FREQ extends Frequency> FREQ getFrequency(FrequencyType<FREQ> type) {
        FrequencyData frequencyData = this.getFrequencyData(type);
        if (frequencyData == null) {
            return null;
        }
        return (FREQ)frequencyData.selectedFrequency;
    }

    @Nullable
    private <FREQ extends Frequency> FrequencyData getFrequencyData(FrequencyType<FREQ> type) {
        return type == FrequencyType.SECURITY ? this.securityFrequency : (FrequencyData)this.nonSecurityFrequencies.get(type);
    }

    public <FREQ extends Frequency> void unsetFrequency(FrequencyType<FREQ> type) {
        this.unsetFrequency(type, this.getFrequencyData(type));
    }

    private <FREQ extends Frequency> void unsetFrequency(FrequencyType<FREQ> type, FrequencyData frequencyData) {
        if (frequencyData != null && frequencyData.selectedFrequency != null) {
            this.deactivate(type, frequencyData);
            frequencyData.clearFrequency();
            this.setNeedsNotify(frequencyData);
        }
    }

    public <FREQ extends Frequency> List<FREQ> getPublicCache(FrequencyType<FREQ> type) {
        return this.getCache(SecurityMode.PUBLIC, type);
    }

    public <FREQ extends Frequency> List<FREQ> getPrivateCache(FrequencyType<FREQ> type) {
        return this.getCache(SecurityMode.PRIVATE, type);
    }

    public <FREQ extends Frequency> List<FREQ> getTrustedCache(FrequencyType<FREQ> type) {
        return this.getCache(SecurityMode.TRUSTED, type);
    }

    private Map<FrequencyType<?>, List<? extends Frequency>> getCache(SecurityMode securityMode) {
        return this.frequencyCache.computeIfAbsent(securityMode, mode -> new LinkedHashMap());
    }

    private <FREQ extends Frequency> List<FREQ> getCache(SecurityMode securityMode, FrequencyType<FREQ> type) {
        return this.getCache(securityMode).computeIfAbsent(type, t -> new ArrayList());
    }

    public <FREQ extends Frequency> void setFrequencyFromData(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, UUID player) {
        FrequencyData frequencyData;
        if (player != null && (frequencyData = this.getFrequencyData(type)) != null) {
            this.setFrequencyFromData(type, data, player, frequencyData);
        }
    }

    private <FREQ extends Frequency> void setFrequencyFromData(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, @NotNull UUID player, FrequencyData frequencyData) {
        Frequency oldFrequency = frequencyData.selectedFrequency;
        FrequencyManager<FREQ> manager = null;
        Frequency freq = null;
        if (!Objects.equals(data.ownerUUID(), player) && SecurityUtils.get().isTrusted(data.securityMode(), data.ownerUUID(), player) && (freq = (manager = type.getManager(data, data.ownerUUID())).getFrequency(data.key())) == null) {
            data = new Frequency.FrequencyIdentity(data.key(), data.securityMode(), player);
        }
        if (freq == null) {
            manager = type.getManager(data, player);
            freq = manager.getOrCreateFrequency(data, player);
        }
        if (!freq.equals(oldFrequency)) {
            manager.deactivate(oldFrequency, this.tile);
            freq.update(this.tile);
            frequencyData.setFrequency(freq);
            this.setNeedsNotify(frequencyData);
        }
    }

    public void removeFrequencyFromData(FrequencyType<?> type, Frequency.FrequencyIdentity data, UUID player) {
        FrequencyData frequencyData;
        FrequencyManager<?> manager = type.getManager(data, data.ownerUUID() == null ? player : data.ownerUUID());
        if (manager != null && manager.remove(data.key(), player) && (frequencyData = this.getFrequencyData(type)) != null) {
            this.setNeedsNotify(frequencyData);
        }
    }

    private <FREQ extends Frequency> void updateFrequency(FrequencyType<FREQ> type, FrequencyData frequencyData) {
        if (frequencyData.selectedFrequency != null) {
            if (frequencyData.selectedFrequency.isValid()) {
                UUID ownerUUID;
                boolean unsetFrequency = frequencyData.selectedFrequency.isRemoved();
                if (!unsetFrequency && type != FrequencyType.SECURITY && frequencyData.selectedFrequency.getSecurity() == SecurityMode.TRUSTED && (ownerUUID = this.tile.getOwnerUUID()) != null && !frequencyData.selectedFrequency.ownerMatches(ownerUUID)) {
                    SecurityFrequency security = FrequencyType.SECURITY.getManager(null, SecurityMode.PUBLIC).getFrequency(frequencyData.selectedFrequency.getOwner());
                    boolean bl = unsetFrequency = security != null && !security.isTrusted(ownerUUID);
                }
                if (unsetFrequency) {
                    FrequencyManager<Frequency> manager = type.getFrequencyManager(frequencyData.selectedFrequency);
                    if (manager != null) {
                        manager.deactivate(frequencyData.selectedFrequency, this.tile);
                    }
                    frequencyData.clearFrequency();
                    this.setNeedsNotify(frequencyData);
                }
            } else {
                Frequency frequency = frequencyData.selectedFrequency;
                FrequencyManager<Frequency> manager = type.getFrequencyManager(frequency);
                if (manager == null) {
                    frequencyData.clearFrequency();
                } else {
                    frequencyData.setFrequency(manager.validateAndUpdate(this.tile, frequency));
                }
                this.setNeedsNotify(frequencyData);
            }
        }
    }

    private void setNeedsNotify(FrequencyData data) {
        if (data.notifyNeighbors) {
            this.needsNotify = true;
        }
        this.needsSave = true;
    }

    private <FREQ extends Frequency> void deactivate(FrequencyType<FREQ> type, FrequencyData frequencyData) {
        FrequencyManager<Frequency> manager;
        if (frequencyData.selectedFrequency != null && (manager = type.getFrequencyManager(frequencyData.selectedFrequency)) != null) {
            manager.deactivate(frequencyData.selectedFrequency, this.tile);
        }
    }

    @Override
    public String getComponentKey() {
        return "component_frequency";
    }

    @Override
    public void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        if (!this.tile.isRemote()) {
            for (FrequencyType key : this.nonSecurityFrequencies.keySet()) {
                this.setFrequencyFromComponent(input, key);
            }
        }
    }

    private <FREQ extends Frequency> void setFrequencyFromComponent(BlockEntity.DataComponentInput input, FrequencyType<FREQ> type) {
        FrequencyAware frequencyAware;
        DataComponentType<FrequencyAware<FREQ>> frequencyComponent = MekanismDataComponents.getFrequencyComponent(type);
        if (frequencyComponent != null && (frequencyAware = (FrequencyAware)input.get(frequencyComponent)) != null && frequencyAware.identity().isPresent()) {
            this.setFrequencyFromData(type, frequencyAware.identity().get(), frequencyAware.getOwner());
        }
    }

    @Override
    public void addRemapEntries(List<DataComponentType<?>> remapEntries) {
        for (FrequencyType type : this.nonSecurityFrequencies.keySet()) {
            DataComponentType frequencyComponent = MekanismDataComponents.getFrequencyComponent(type);
            if (frequencyComponent != null && !remapEntries.contains(frequencyComponent)) {
                remapEntries.add(frequencyComponent);
            }
            if (type != FrequencyType.QIO || remapEntries.contains(MekanismDataComponents.COLOR.get())) continue;
            remapEntries.add((DataComponentType)MekanismDataComponents.COLOR.get());
        }
    }

    @Override
    public void collectImplicitComponents(DataComponentMap.Builder builder) {
        for (Map.Entry entry : this.nonSecurityFrequencies.entrySet()) {
            this.collectFrequencyComponents(builder, (FrequencyType)entry.getKey(), (FrequencyData)entry.getValue());
        }
    }

    private <FREQ extends Frequency> void collectFrequencyComponents(DataComponentMap.Builder builder, FrequencyType<FREQ> type, FrequencyData frequencyData) {
        DataComponentType<FrequencyAware<FREQ>> frequencyComponent;
        if (frequencyData.selectedFrequency != null && (frequencyComponent = MekanismDataComponents.getFrequencyComponent(type)) != null) {
            Frequency frequency;
            builder.set(frequencyComponent, new FrequencyAware<Frequency>(frequencyData.selectedFrequency));
            if (type == FrequencyType.QIO && (frequency = frequencyData.selectedFrequency) instanceof IColorableFrequency) {
                IColorableFrequency colorableFrequency = (IColorableFrequency)((Object)frequency);
                builder.set(MekanismDataComponents.COLOR, (Object)colorableFrequency.getColor());
            }
        }
    }

    @Override
    public void deserialize(CompoundTag frequencyNBT, HolderLookup.Provider provider) {
        if (this.securityFrequency != null) {
            TileComponentFrequency.deserializeFrequency(provider, frequencyNBT, FrequencyType.SECURITY, this.securityFrequency);
        }
        for (Map.Entry entry : this.nonSecurityFrequencies.entrySet()) {
            FrequencyType type = (FrequencyType)entry.getKey();
            TileComponentFrequency.deserializeFrequency(provider, frequencyNBT, type, (FrequencyData)entry.getValue());
        }
    }

    private static void deserializeFrequency(HolderLookup.Provider provider, CompoundTag frequencyNBT, FrequencyType<?> type, FrequencyData frequencyData) {
        if (frequencyNBT.contains(type.getName(), 10)) {
            frequencyData.setFrequency((Frequency)type.create(provider, frequencyNBT.getCompound(type.getName())));
        }
    }

    @Override
    public CompoundTag serialize(HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        CompoundTag frequencyNBT = new CompoundTag();
        if (this.securityFrequency != null) {
            TileComponentFrequency.serializeFrequency((DynamicOps<Tag>)ops, FrequencyType.SECURITY, this.securityFrequency, frequencyNBT);
        }
        for (Map.Entry entry : this.nonSecurityFrequencies.entrySet()) {
            TileComponentFrequency.serializeFrequency((DynamicOps<Tag>)ops, (FrequencyType)entry.getKey(), (FrequencyData)entry.getValue(), frequencyNBT);
        }
        return frequencyNBT;
    }

    private static void serializeFrequency(DynamicOps<Tag> ops, FrequencyType<?> type, FrequencyData frequencyData, CompoundTag frequencyNBT) {
        Frequency frequency = frequencyData.selectedFrequency;
        if (frequency != null) {
            DataResult encodedIdentity = type.getIdentitySerializer().codec().encodeStart(ops, (Object)frequency.getIdentity());
            if (encodedIdentity.isSuccess()) {
                frequencyNBT.put(frequency.getType().getName(), (Tag)encodedIdentity.getOrThrow());
            } else {
                encodedIdentity.ifError(error -> Mekanism.logger.warn("Failed to serialize frequency identity: {}", (Object)error.message()));
            }
        }
    }

    public void readConfiguredFrequencies(HolderLookup.Provider provider, Player player, CompoundTag data) {
        if (this.hasCustomFrequencies() && data.contains(this.getComponentKey(), 10)) {
            RegistryOps registryOps = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            CompoundTag frequencyNBT = data.getCompound(this.getComponentKey());
            for (Map.Entry entry : this.nonSecurityFrequencies.entrySet()) {
                FrequencyType type = (FrequencyType)entry.getKey();
                if (type == FrequencyType.SECURITY) continue;
                if (frequencyNBT.contains(type.getName(), 10)) {
                    CompoundTag frequencyData = frequencyNBT.getCompound(type.getName());
                    DataResult decodedIdentity = type.getIdentitySerializer().codec().parse((DynamicOps)registryOps, (Object)frequencyData);
                    if (decodedIdentity.isSuccess()) {
                        Frequency.FrequencyIdentity identity = (Frequency.FrequencyIdentity)decodedIdentity.getOrThrow();
                        if (identity.ownerUUID() != null) {
                            if (identity.securityMode() != SecurityMode.PUBLIC && !identity.ownerUUID().equals(player.getUUID())) continue;
                            this.setFrequencyFromData(type, identity, identity.ownerUUID(), (FrequencyData)entry.getValue());
                            continue;
                        }
                    } else {
                        decodedIdentity.ifError(error -> Mekanism.logger.warn("Failed to deserialize frequency identity: {}", (Object)error.message()));
                    }
                }
                this.unsetFrequency(type, (FrequencyData)entry.getValue());
            }
        }
    }

    public void writeConfiguredFrequencies(HolderLookup.Provider provider, CompoundTag data) {
        RegistryOps registryOps = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        CompoundTag frequencyNBT = new CompoundTag();
        for (Map.Entry entry : this.nonSecurityFrequencies.entrySet()) {
            FrequencyType type = (FrequencyType)entry.getKey();
            Frequency frequency = ((FrequencyData)entry.getValue()).selectedFrequency;
            if (frequency == null || type == FrequencyType.SECURITY) continue;
            DataResult encoded = type.getIdentitySerializer().codec().encodeStart((DynamicOps)registryOps, (Object)frequency.getIdentity());
            if (encoded.isSuccess()) {
                frequencyNBT.put(type.getName(), (Tag)encoded.getOrThrow());
                continue;
            }
            encoded.ifError(error -> Mekanism.logger.warn("Failed to encode frequency identity: {}", (Object)error.message()));
        }
        if (!frequencyNBT.isEmpty()) {
            data.put(this.getComponentKey(), (Tag)frequencyNBT);
        }
    }

    @Override
    public void invalidate() {
        if (!this.tile.isRemote()) {
            for (Map.Entry entry : this.nonSecurityFrequencies.entrySet()) {
                this.deactivate((FrequencyType)entry.getKey(), (FrequencyData)entry.getValue());
            }
            if (this.securityFrequency != null) {
                this.deactivate(FrequencyType.SECURITY, this.securityFrequency);
            }
        }
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        if (this.securityFrequency != null) {
            this.trackFrequencyForMainContainer(container, this.securityFrequency, FrequencyType.SECURITY);
        }
        for (Map.Entry entry : this.nonSecurityFrequencies.entrySet()) {
            FrequencyData data = (FrequencyData)entry.getValue();
            this.trackFrequencyForMainContainer(container, data, (FrequencyType)entry.getKey());
        }
    }

    private void trackFrequencyForMainContainer(MekanismContainer container, FrequencyData data, FrequencyType<?> key) {
        if (data.needsContainerSync) {
            container.track(SyncableFrequency.create(key, () -> data.selectedFrequency, data::setFrequency));
        }
        if (data.needsListCache) {
            this.track(container, key);
        }
    }

    private <FREQ extends Frequency> Consumer<@NotNull List<FREQ>> getSetter(SecurityMode securityMode, FrequencyType<FREQ> type) {
        Map<FrequencyType<?>, List<? extends Frequency>> cache = this.getCache(securityMode);
        return value -> cache.put(type, (List<? extends Frequency>)value);
    }

    private <FREQ extends Frequency> void track(MekanismContainer container, FrequencyType<FREQ> type) {
        Consumer<@NotNull List<FREQUENCY>> publicSetter = this.getSetter(SecurityMode.PUBLIC, type);
        Consumer<@NotNull List<FREQUENCY>> privateSetter = this.getSetter(SecurityMode.PRIVATE, type);
        Consumer<@NotNull List<FREQUENCY>> trustedSetter = this.getSetter(SecurityMode.TRUSTED, type);
        if (container.getLevel().isClientSide()) {
            container.track(SyncableFrequencyList.create(type, () -> this.getPublicCache(type), publicSetter));
            container.track(SyncableFrequencyList.create(type, () -> this.getPrivateCache(type), privateSetter));
            container.track(SyncableFrequencyList.create(type, () -> this.getTrustedCache(type), trustedSetter));
        } else {
            container.track(SyncableFrequencyList.create(type, () -> type.getManagerWrapper().getPublicManager().getFrequencies(), publicSetter));
            container.track(SyncableFrequencyList.create(type, () -> type.getManagerWrapper().getPrivateManager(container.getPlayerUUID()).getFrequencies(), privateSetter));
            container.track(SyncableFrequencyList.create(type, () -> type.getManagerWrapper().getTrustedManager(container.getPlayerUUID()).getFrequencies(), trustedSetter));
        }
    }

    private static final class FrequencyData {
        private final boolean needsContainerSync;
        private final boolean needsListCache;
        private final boolean notifyNeighbors;
        @Nullable
        private Frequency selectedFrequency;

        private FrequencyData(boolean needsContainerSync, boolean needsListCache, boolean notifyNeighbors) {
            this.needsContainerSync = needsContainerSync;
            this.needsListCache = needsListCache;
            this.notifyNeighbors = notifyNeighbors;
        }

        public void setFrequency(@Nullable Frequency frequency) {
            this.selectedFrequency = frequency;
        }

        public void clearFrequency() {
            this.setFrequency(null);
        }
    }
}

