/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.ToIntFunction;
import mekanism.common.lib.math.voxel.BlockPosBuilder;
import mekanism.common.lib.math.voxel.VoxelPlane;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IMultiblockBase;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;

public class Structure {
    public static final Structure INVALID = new Structure();
    private final Map<BlockPos, IMultiblockBase> nodes = new Object2ObjectOpenHashMap();
    private final Map<Axis, Int2ObjectSortedMap<VoxelPlane>> minorPlaneMap = new EnumMap<Axis, Int2ObjectSortedMap<VoxelPlane>>(Axis.class);
    private final Map<Axis, Int2ObjectSortedMap<VoxelPlane>> planeMap = new EnumMap<Axis, Int2ObjectSortedMap<VoxelPlane>>(Axis.class);
    private boolean valid;
    private long updateTimestamp;
    private boolean didUpdate;
    private MultiblockData multiblockData;
    private IMultiblock<?> controller;

    private Structure() {
    }

    public Structure(IMultiblockBase node) {
        this.init(node);
        this.valid = true;
    }

    private void init(IMultiblockBase node) {
        BlockPos pos = node.getBlockPos();
        this.nodes.put(pos, node);
        for (Axis axis : Axis.AXES) {
            this.getMinorAxisMap(axis).put(axis.getCoord(pos), (Object)new VoxelPlane(axis, pos, node instanceof IMultiblock));
        }
        if (node instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)node;
            if (this.getController() == null || multiblock.canBeMaster()) {
                this.controller = multiblock;
            }
        }
    }

    public MultiblockData getMultiblockData() {
        return this.multiblockData;
    }

    public void setMultiblockData(MultiblockData multiblockData) {
        boolean changed = this.multiblockData != multiblockData;
        this.multiblockData = multiblockData;
        if (changed) {
            for (IMultiblockBase node : this.nodes.values()) {
                node.resetForFormed();
            }
        }
    }

    public IMultiblock<?> getController() {
        return this.controller;
    }

    public MultiblockManager<?> getManager() {
        return this.getController() != null && this.valid ? this.getController().getManager() : null;
    }

    public IMultiblockBase getTile(BlockPos pos) {
        return this.nodes.get(pos);
    }

    public Int2ObjectSortedMap<VoxelPlane> getMinorAxisMap(Axis axis) {
        return this.minorPlaneMap.computeIfAbsent(axis, k -> new Int2ObjectRBTreeMap());
    }

    public Int2ObjectSortedMap<VoxelPlane> getMajorAxisMap(Axis axis) {
        return this.planeMap.computeIfAbsent(axis, k -> new Int2ObjectRBTreeMap());
    }

    public void markForUpdate(Level world, boolean invalidate) {
        this.updateTimestamp = world.getGameTime();
        this.didUpdate = false;
        if (invalidate) {
            this.invalidate(world);
        } else {
            this.removeMultiblock(world);
        }
    }

    public <TILE extends BlockEntity> void doImmediateUpdate(TILE tile, boolean tryValidate) {
        this.updateTimestamp = tile.getLevel().getGameTime() - 1L;
        this.didUpdate = false;
        this.invalidate(tile.getLevel());
        this.tick(tile, tryValidate);
    }

    public <TILE extends BlockEntity> void tick(TILE tile, boolean tryValidate) {
        if (!this.didUpdate && this.updateTimestamp == tile.getLevel().getGameTime() - 1L) {
            this.didUpdate = true;
            this.runUpdate(tile);
        }
        if (tryValidate && !this.isValid()) {
            Structure.validate((IMultiblockBase)tile, (Long2ObjectMap<ChunkAccess>)new Long2ObjectOpenHashMap());
        }
    }

    public <TILE extends BlockEntity> FormationProtocol.FormationResult runUpdate(TILE tile) {
        if (this.getController() != null && this.multiblockData == null) {
            return this.getController().createFormationProtocol().doUpdate();
        }
        this.removeMultiblock(tile.getLevel());
        return FormationProtocol.FormationResult.FAIL;
    }

    public void add(Structure s) {
        if (s != this) {
            VoxelPlane minorPlane;
            VoxelPlane majorPlane;
            VoxelPlane value;
            int key;
            Int2ObjectMap.Entry e;
            ObjectIterator iterator;
            Int2ObjectSortedMap<VoxelPlane> majorMap;
            Int2ObjectSortedMap<VoxelPlane> minorMap;
            Axis axis;
            if (s.getController() != null && s.getController().canBeMaster() && (this.getController() == null || !this.getController().canBeMaster())) {
                this.controller = s.getController();
            }
            MultiblockManager<?> manager = this.getManager();
            for (Map.Entry<BlockPos, IMultiblockBase> entry : s.nodes.entrySet()) {
                IMultiblockBase v = entry.getValue();
                this.nodes.put(entry.getKey(), v);
                v.setStructure(manager, this);
            }
            for (Map.Entry<Object, IMultiblockBase> entry : s.minorPlaneMap.entrySet()) {
                axis = (Axis)((Object)entry.getKey());
                minorMap = this.getMinorAxisMap(axis);
                majorMap = this.getMajorAxisMap(axis);
                iterator = Int2ObjectMaps.fastIterator((Int2ObjectMap)((Int2ObjectMap)entry.getValue()));
                while (iterator.hasNext()) {
                    e = (Int2ObjectMap.Entry)iterator.next();
                    key = e.getIntKey();
                    value = (VoxelPlane)e.getValue();
                    majorPlane = (VoxelPlane)majorMap.get(key);
                    if (majorPlane != null) {
                        majorPlane.merge(value);
                        continue;
                    }
                    minorPlane = (VoxelPlane)minorMap.get(key);
                    if (minorPlane == null) {
                        minorMap.put(key, (Object)value);
                        continue;
                    }
                    minorPlane.merge(value);
                    if (!minorPlane.hasFrame() || minorPlane.length() < 2 || minorPlane.height() < 2) continue;
                    majorMap.put(key, (Object)minorPlane);
                    minorMap.remove(key);
                }
            }
            for (Map.Entry<Object, IMultiblockBase> entry : s.planeMap.entrySet()) {
                axis = (Axis)((Object)entry.getKey());
                minorMap = this.getMinorAxisMap(axis);
                majorMap = this.getMajorAxisMap(axis);
                iterator = Int2ObjectMaps.fastIterator((Int2ObjectMap)((Int2ObjectMap)entry.getValue()));
                while (iterator.hasNext()) {
                    e = (Int2ObjectMap.Entry)iterator.next();
                    key = e.getIntKey();
                    value = (VoxelPlane)e.getValue();
                    majorPlane = (VoxelPlane)majorMap.get(key);
                    if (majorPlane == null) {
                        majorPlane = value;
                        majorMap.put(key, (Object)majorPlane);
                        minorPlane = (VoxelPlane)minorMap.get(key);
                        if (minorPlane == null) continue;
                        majorPlane.merge(minorPlane);
                        minorMap.remove(key);
                        continue;
                    }
                    majorPlane.merge(value);
                }
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate(Level world) {
        this.removeMultiblock(world);
        this.valid = false;
    }

    public void removeMultiblock(Level world) {
        if (this.multiblockData != null) {
            this.multiblockData.remove(world, this);
            this.multiblockData = null;
        }
    }

    public boolean contains(BlockPos pos) {
        return this.nodes.containsKey(pos);
    }

    public int size() {
        return this.nodes.size();
    }

    private static void validate(IMultiblockBase node, Long2ObjectMap<ChunkAccess> chunkMap) {
        if (node instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)node;
            if (!multiblock.getStructure().isValid()) {
                multiblock.resetStructure(multiblock.getManager());
            }
        } else if (node instanceof IStructuralMultiblock) {
            node.resetStructure(null);
        }
        FormationProtocol.explore(node.getLevel(), chunkMap, node.getBlockPos(), node, (level, chunks, start, n, pos) -> {
            if (pos.equals((Object)start)) {
                return true;
            }
            BlockEntity tile = WorldUtils.getTileEntity((LevelAccessor)level, (Long2ObjectMap<ChunkAccess>)chunks, pos);
            if (!(tile instanceof IMultiblockBase)) return false;
            IMultiblockBase adj = (IMultiblockBase)tile;
            if (!Structure.isCompatible(n, adj)) return false;
            boolean didMerge = false;
            if (n instanceof IStructuralMultiblock) {
                IStructuralMultiblock structuralN = (IStructuralMultiblock)n;
                if (adj instanceof IStructuralMultiblock) {
                    IStructuralMultiblock structuralAdj = (IStructuralMultiblock)adj;
                    HashSet managers = new HashSet(structuralN.getStructureMap().keySet());
                    managers.addAll(structuralAdj.getStructureMap().keySet());
                    Iterator iterator = managers.iterator();
                    while (iterator.hasNext()) {
                        MultiblockManager multiblockManager = (MultiblockManager)iterator.next();
                        didMerge |= Structure.mergeIfNecessary(n, adj, multiblockManager, true);
                    }
                    return didMerge;
                }
            }
            if (n instanceof IStructuralMultiblock) {
                if (Structure.hasStructure(n, (IMultiblock)adj)) return false;
                Structure.validate(adj, (Long2ObjectMap<ChunkAccess>)chunks);
                return false;
            }
            if (!(adj instanceof IStructuralMultiblock)) return Structure.mergeIfNecessary(n, adj, Structure.getManager(n), false);
            return Structure.mergeIfNecessary(n, adj, Structure.getManager(n), false);
        });
    }

    private static boolean hasStructure(IMultiblockBase structural, IMultiblock<?> multiblock) {
        return structural.getStructure(multiblock.getManager()) == multiblock.getStructure();
    }

    private static boolean mergeIfNecessary(IMultiblockBase node, IMultiblockBase adj, MultiblockManager<?> manager, boolean bothStructural) {
        Structure adjStructure;
        Structure nodeStructure = node.getStructure(manager);
        if (!nodeStructure.isValid()) {
            nodeStructure = node.resetStructure(manager);
        }
        if (!(adjStructure = adj.getStructure(manager)).isValid()) {
            adjStructure = adj.resetStructure(manager);
        }
        if (!node.hasStructure(adjStructure)) {
            Structure changed;
            if (bothStructural && nodeStructure.getMultiblockData() == null == (adjStructure.getMultiblockData() != null)) {
                return false;
            }
            if (nodeStructure.size() >= adjStructure.size() || nodeStructure.getManager() != null && adjStructure.getManager() == null) {
                changed = nodeStructure;
                changed.add(adjStructure);
            } else {
                changed = adjStructure;
                changed.add(nodeStructure);
            }
            changed.markForUpdate(node.getLevel(), false);
            return true;
        }
        return false;
    }

    private static boolean isCompatible(IMultiblockBase node, IMultiblockBase other) {
        MultiblockManager<?> manager = Structure.getManager(node);
        MultiblockManager<?> otherManager = Structure.getManager(other);
        if (manager != null && otherManager != null) {
            return manager == otherManager;
        }
        if (manager == null && otherManager == null) {
            return true;
        }
        if (manager == null && node instanceof IStructuralMultiblock) {
            IStructuralMultiblock multiblock = (IStructuralMultiblock)node;
            return multiblock.canInterface(otherManager);
        }
        if (otherManager == null && other instanceof IStructuralMultiblock) {
            IStructuralMultiblock multiblock = (IStructuralMultiblock)other;
            return multiblock.canInterface(manager);
        }
        return false;
    }

    private static MultiblockManager<?> getManager(IMultiblockBase node) {
        MultiblockManager multiblockManager;
        if (node instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)node;
            multiblockManager = multiblock.getManager();
        } else {
            multiblockManager = null;
        }
        return multiblockManager;
    }

    public static enum Axis {
        X(Vec3i::getX),
        Y(Vec3i::getY),
        Z(Vec3i::getZ);

        private final ToIntFunction<BlockPos> posMapper;
        static final Axis[] AXES;

        private Axis(ToIntFunction<BlockPos> posMapper) {
            this.posMapper = posMapper;
        }

        public int getCoord(BlockPos pos) {
            return this.posMapper.applyAsInt(pos);
        }

        public void set(BlockPosBuilder pos, int val) {
            pos.set(this, val);
        }

        public Axis horizontal() {
            return this == X ? Z : X;
        }

        public Axis vertical() {
            return this == Y ? Z : Y;
        }

        public static Axis get(Direction side) {
            return AXES[side.getAxis().ordinal()];
        }

        static {
            AXES = Axis.values();
        }
    }
}

