/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mekanism.api.Chunk3D;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.radiation.IRadiationSource;
import mekanism.api.radiation.capability.IRadiationEntity;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.LevelAndMaxMagnitude;
import mekanism.common.lib.radiation.PlayerExposure;
import mekanism.common.lib.radiation.RadiationLevelData;
import mekanism.common.lib.radiation.RadiationSource;
import mekanism.common.lib.radiation.RadiationUtil;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismDamageTypes;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class RadiationManager
implements IRadiationManager {
    private static final RandomSource RAND = RandomSource.create();
    private static boolean shouldDecayThisTick = false;
    static final double BASELINE = 1.0E-7;
    static final double MIN_MAGNITUDE = 1.0E-5;

    public static RadiationManager get() {
        return (RadiationManager)INSTANCE;
    }

    @Override
    public boolean isRadiationEnabled() {
        return RadiationManager.isGlobalRadiationEnabled();
    }

    public static boolean isGlobalRadiationEnabled() {
        return MekanismConfig.general.radiationEnabled.getOrDefault();
    }

    @Nullable
    private static RadiationLevelData getData(Level level) {
        return (RadiationLevelData)level.getExistingDataOrNull(MekanismAttachmentTypes.RADIATION_LEVEL_DATA);
    }

    private static RadiationLevelData getOrCreateData(Level level) {
        return (RadiationLevelData)level.getData(MekanismAttachmentTypes.RADIATION_LEVEL_DATA);
    }

    @Override
    public double baselineRadiation() {
        return 1.0E-7;
    }

    @Override
    public double minRadiationMagnitude() {
        return 1.0E-5;
    }

    @Override
    public DamageSource getRadiationDamageSource(RegistryAccess registryAccess) {
        return MekanismDamageTypes.RADIATION.source(registryAccess);
    }

    @Override
    public ResourceKey<DamageType> getRadiationDamageTypeKey() {
        return MekanismDamageTypes.RADIATION.key();
    }

    @Override
    public double getRadiationLevel(Entity entity) {
        return this.getRadiationLevel(entity.level(), entity.blockPosition());
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.15")
    public Table<Chunk3D, GlobalPos, IRadiationSource> getRadiationSources() {
        HashBasedTable table = HashBasedTable.create();
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return table;
        }
        for (ServerLevel level : currentServer.getAllLevels()) {
            RadiationLevelData radiationLevelData = RadiationManager.getData((Level)level);
            if (radiationLevelData == null || radiationLevelData.isEmpty()) continue;
            for (RadiationSource value : radiationLevelData.values()) {
                final GlobalPos globalPos = new GlobalPos(level.dimension(), value.getPosition());
                table.put((Object)new Chunk3D(globalPos), (Object)globalPos, (Object)new RadiationSource(this, value.getPosition(), value.getMagnitude()){

                    @Override
                    public GlobalPos getPos() {
                        return globalPos;
                    }
                });
            }
        }
        return table;
    }

    @Override
    public List<IRadiationSource> getRadiationSources(Level level, int chunkX, int chunkZ) {
        RadiationLevelData radiationLevelData = RadiationManager.getData(level);
        if (radiationLevelData == null) {
            return Collections.emptyList();
        }
        Iterator<RadiationSource> sourceIterator = radiationLevelData.getSources(chunkX, chunkZ);
        if (!sourceIterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<IRadiationSource> sources = new ArrayList<IRadiationSource>();
        while (sourceIterator.hasNext()) {
            sources.add(sourceIterator.next());
        }
        return sources;
    }

    @Override
    public void removeRadiationSources(Level level, int chunkX, int chunkZ) {
        RadiationLevelData radiationLevelData = RadiationManager.getData(level);
        if (radiationLevelData == null) {
            return;
        }
        if (radiationLevelData.removeRadiationSources(chunkX, chunkZ)) {
            PlayerExposure.updateClientRadiationForAll((ResourceKey<Level>)level.dimension());
        }
    }

    @Override
    public void removeRadiationSource(Level level, BlockPos pos) {
        RadiationLevelData radiationLevelData = RadiationManager.getData(level);
        if (radiationLevelData == null) {
            return;
        }
        if (radiationLevelData.removeRadiationSource(pos)) {
            PlayerExposure.updateClientRadiationForAll((ResourceKey<Level>)level.dimension());
        }
    }

    @Override
    public double getRadiationLevel(Level level, BlockPos pos) {
        RadiationLevelData radiationLevelData = RadiationManager.getData(level);
        if (radiationLevelData == null) {
            return this.baselineRadiation();
        }
        return radiationLevelData.getRadiationLevelAndMaxMagnitude(pos).level();
    }

    public LevelAndMaxMagnitude getRadiationLevelAndMaxMagnitude(Entity entity) {
        RadiationLevelData radiationLevelData = RadiationManager.getData(entity.level());
        if (radiationLevelData == null) {
            return LevelAndMaxMagnitude.BASELINE;
        }
        return radiationLevelData.getRadiationLevelAndMaxMagnitude(entity.blockPosition());
    }

    @Override
    public void radiate(Level level, BlockPos pos, double magnitude) {
        if (!RadiationManager.isGlobalRadiationEnabled()) {
            return;
        }
        RadiationManager.getOrCreateData(level).radiate(pos, magnitude);
        PlayerExposure.updateClientRadiationForAll((ResourceKey<Level>)level.dimension());
    }

    @Override
    public void radiate(LivingEntity entity, double magnitude) {
        IRadiationEntity radiationEntity;
        Player player;
        if (!RadiationManager.isGlobalRadiationEnabled()) {
            return;
        }
        if ((!(entity instanceof Player) || MekanismUtils.isPlayingMode(player = (Player)entity)) && (radiationEntity = (IRadiationEntity)entity.getCapability(Capabilities.RADIATION_ENTITY)) != null) {
            radiationEntity.radiate(magnitude * (1.0 - Math.min(1.0, RadiationUtil.getRadiationResistance(entity))));
        }
    }

    @Override
    public void dumpRadiation(Level level, BlockPos pos, IChemicalHandler chemicalHandler, boolean clearRadioactive) {
        int gasTanks = chemicalHandler.getChemicalTanks();
        for (int tank = 0; tank < gasTanks; ++tank) {
            if (!this.dumpRadiation(level, pos, chemicalHandler.getChemicalInTank(tank)) || !clearRadioactive) continue;
            chemicalHandler.setChemicalInTank(tank, ChemicalStack.EMPTY);
        }
    }

    @Override
    public void dumpRadiation(Level level, BlockPos pos, List<IChemicalTank> chemicalTanks, boolean clearRadioactive) {
        for (IChemicalTank gasTank : chemicalTanks) {
            if (!this.dumpRadiation(level, pos, gasTank.getStack()) || !clearRadioactive) continue;
            gasTank.setEmpty();
        }
    }

    @Override
    public boolean dumpRadiation(Level level, BlockPos pos, ChemicalStack stack) {
        double radioactivity;
        if (RadiationManager.isGlobalRadiationEnabled() && !stack.isEmpty() && (radioactivity = stack.getRadioactivity()) > 0.0) {
            this.radiate(level, pos, radioactivity);
            return true;
        }
        return false;
    }

    public void clearSources() {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        boolean hadEntries = false;
        for (ServerLevel level : currentServer.getAllLevels()) {
            RadiationLevelData radiationLevelData = RadiationManager.getData((Level)level);
            if (radiationLevelData == null || radiationLevelData.isEmpty()) continue;
            hadEntries = true;
            radiationLevelData.clearAll();
        }
        if (hadEntries) {
            PlayerExposure.updateClientRadiationForAll();
        }
    }

    @SubscribeEvent
    public void onTickPre(ServerTickEvent.Pre event) {
        shouldDecayThisTick = RadiationManager.isGlobalRadiationEnabled() && event.getServer().tickRateManager().runsNormally() && RAND.nextInt(20) == 0;
    }

    public void tickServerWorld(ServerLevel world) {
        if (!shouldDecayThisTick) {
            return;
        }
        RadiationLevelData radiationLevelData = RadiationManager.getData((Level)world);
        if (radiationLevelData == null || radiationLevelData.isEmpty()) {
            return;
        }
        radiationLevelData.decay();
        PlayerExposure.updateClientRadiationForAll((ResourceKey<Level>)world.dimension());
    }
}

