/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

@NothingNullByDefault
public enum TransmissionType implements IHasTranslationKey.IHasEnumNameTranslationKey,
StringRepresentable
{
    ENERGY("EnergyNetwork", "energy", MekanismLang.TRANSMISSION_TYPE_ENERGY, 0),
    FLUID("FluidNetwork", "fluids", MekanismLang.TRANSMISSION_TYPE_FLUID, 1),
    CHEMICAL("ChemicalNetwork", "chemicals", MekanismLang.TRANSMISSION_TYPE_CHEMICALS, 2),
    ITEM("InventoryNetwork", "items", MekanismLang.TRANSMISSION_TYPE_ITEM, 6),
    HEAT("HeatNetwork", "heat", MekanismLang.TRANSMISSION_TYPE_HEAT, 7);

    public static final Codec<TransmissionType> CODEC;
    public static final IntFunction<TransmissionType> BY_ID;
    public static final StreamCodec<ByteBuf, TransmissionType> STREAM_CODEC;
    private final String name;
    private final String transmission;
    private final ILangEntry langEntry;
    private final int legacyOrdinal;

    private TransmissionType(String name, String transmission, ILangEntry langEntry, int legacyOrdinal) {
        this.name = name;
        this.transmission = transmission;
        this.langEntry = langEntry;
        this.legacyOrdinal = legacyOrdinal;
    }

    public String getName() {
        return this.name;
    }

    public String getTransmission() {
        return this.transmission;
    }

    public ILangEntry getLangEntry() {
        return this.langEntry;
    }

    @Override
    public String getTranslationKey() {
        return this.langEntry.getTranslationKey();
    }

    public boolean checkTransmissionType(Transmitter<?, ?, ?> transmitter) {
        return transmitter.getSupportedTransmissionTypes().contains(this);
    }

    public boolean checkTransmissionType(TileEntityTransmitter transmitter) {
        return this.checkTransmissionType(transmitter.getTransmitter());
    }

    public String getSerializedName() {
        return this.transmission;
    }

    public int getLegacyOrdinal() {
        return this.legacyOrdinal;
    }

    static {
        StringRepresentable[] values = TransmissionType.values();
        Function nameLookup = StringRepresentable.createNameLookup((StringRepresentable[])values, Function.identity());
        Function<String, TransmissionType> remapper = it -> "gases".equals(it) || "infuse_types".equals(it) || "pigments".equals(it) || "slurries".equals(it) ? CHEMICAL : (TransmissionType)nameLookup.apply(it);
        CODEC = new StringRepresentable.EnumCodec((Enum[])values, remapper);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])TransmissionType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

