/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.registries;

import java.util.function.LongSupplier;
import mekanism.api.math.MathUtils;
import mekanism.api.text.ILangEntry;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeCustomSelectionBox;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.block.attribute.AttributeMultiblock;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.util.ChemicalUtil;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.block.attribute.AttributeStateFissionPortMode;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.blocktype.BlockShapes;
import mekanism.generators.common.content.blocktype.Generator;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import mekanism.generators.common.registries.GeneratorsSounds;
import mekanism.generators.common.registries.GeneratorsTileEntityTypes;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntityReactorGlass;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import mekanism.generators.common.tile.fission.TileEntityControlRodAssembly;
import mekanism.generators.common.tile.fission.TileEntityFissionFuelAssembly;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorLogicAdapter;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorPort;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorLogicAdapter;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorPort;
import mekanism.generators.common.tile.fusion.TileEntityLaserFocusMatrix;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineValve;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class GeneratorsBlockTypes {
    public static final Generator<TileEntityHeatGenerator> HEAT_GENERATOR = (Generator)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)Generator.GeneratorBuilder.createGenerator(() -> GeneratorsTileEntityTypes.HEAT_GENERATOR, GeneratorsLang.DESCRIPTION_HEAT_GENERATOR).withGui(() -> GeneratorsContainerTypes.HEAT_GENERATOR)).withEnergyConfig((LongSupplier)MekanismGeneratorsConfig.storageConfig.heatGenerator)).withCustomShape(BlockShapes.HEAT_GENERATOR)).withSound(GeneratorsSounds.HEAT_GENERATOR)).with(new Attribute[]{AttributeUpgradeSupport.MUFFLING_ONLY})).withComputerSupport("heatGenerator")).replace(new Attribute[]{Attributes.ACTIVE_MELT_LIGHT})).with(new Attribute[]{new AttributeParticleFX().add((ParticleOptions)ParticleTypes.SMOKE, rand -> new Pos3D((double)(rand.nextFloat() * 0.6f - 0.3f), (double)(rand.nextFloat() * 6.0f / 16.0f), -0.52)).add((ParticleOptions)ParticleTypes.FLAME, rand -> new Pos3D((double)(rand.nextFloat() * 0.6f - 0.3f), (double)(rand.nextFloat() * 6.0f / 16.0f), -0.52))})).build();
    public static final Generator<TileEntityBioGenerator> BIO_GENERATOR = (Generator)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)Generator.GeneratorBuilder.createGenerator(() -> GeneratorsTileEntityTypes.BIO_GENERATOR, GeneratorsLang.DESCRIPTION_BIO_GENERATOR).withGui(() -> GeneratorsContainerTypes.BIO_GENERATOR)).withEnergyConfig((LongSupplier)MekanismGeneratorsConfig.storageConfig.bioGenerator)).withCustomShape(BlockShapes.BIO_GENERATOR)).withSound(GeneratorsSounds.BIO_GENERATOR)).with(new Attribute[]{AttributeUpgradeSupport.MUFFLING_ONLY})).withComputerSupport("bioGenerator")).replace(new Attribute[]{Attributes.ACTIVE_MELT_LIGHT})).with(new Attribute[]{new AttributeParticleFX().add((ParticleOptions)ParticleTypes.SMOKE, rand -> new Pos3D(0.0, 0.3, -0.25))})).build();
    public static final Generator<TileEntitySolarGenerator> SOLAR_GENERATOR = (Generator)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)Generator.GeneratorBuilder.createGenerator(() -> GeneratorsTileEntityTypes.SOLAR_GENERATOR, GeneratorsLang.DESCRIPTION_SOLAR_GENERATOR).withGui(() -> GeneratorsContainerTypes.SOLAR_GENERATOR)).withEnergyConfig((LongSupplier)MekanismGeneratorsConfig.storageConfig.solarGenerator)).withCustomShape(BlockShapes.SOLAR_GENERATOR)).withSound(GeneratorsSounds.SOLAR_GENERATOR)).with(new Attribute[]{AttributeUpgradeSupport.MUFFLING_ONLY})).withComputerSupport("solarGenerator")).replace(new Attribute[]{Attributes.ACTIVE})).build();
    public static final Generator<TileEntityWindGenerator> WIND_GENERATOR = (Generator)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)Generator.GeneratorBuilder.createGenerator(() -> GeneratorsTileEntityTypes.WIND_GENERATOR, GeneratorsLang.DESCRIPTION_WIND_GENERATOR).withGui(() -> GeneratorsContainerTypes.WIND_GENERATOR)).withEnergyConfig((LongSupplier)MekanismGeneratorsConfig.storageConfig.windGenerator)).withCustomShape(BlockShapes.WIND_GENERATOR)).with(new Attribute[]{AttributeCustomSelectionBox.JAVA})).withSound(GeneratorsSounds.WIND_GENERATOR)).with(new Attribute[]{AttributeUpgradeSupport.MUFFLING_ONLY})).withBounding(new AttributeHasBounding.HandleBoundingBlock(){

        public <DATA> boolean handle(Level level, BlockPos pos, BlockState state, DATA data, AttributeHasBounding.TriBooleanFunction<Level, BlockPos, DATA> consumer) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 4; ++i) {
                mutable.setWithOffset((Vec3i)pos, 0, i + 1, 0);
                if (consumer.accept((Object)level, (Object)mutable, data)) continue;
                return false;
            }
            return true;
        }
    })).withComputerSupport("windGenerator")).build();
    public static final Generator<TileEntityGasGenerator> GAS_BURNING_GENERATOR = (Generator)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)Generator.GeneratorBuilder.createGenerator(() -> GeneratorsTileEntityTypes.GAS_BURNING_GENERATOR, GeneratorsLang.DESCRIPTION_GAS_BURNING_GENERATOR).withGui(() -> GeneratorsContainerTypes.GAS_BURNING_GENERATOR)).withEnergyConfig(() -> MathUtils.multiplyClamped((long)1000L, (long)ChemicalUtil.hydrogenEnergyDensity()))).withCustomShape(BlockShapes.GAS_BURNING_GENERATOR)).with(new Attribute[]{AttributeCustomSelectionBox.JSON})).withSound(GeneratorsSounds.GAS_BURNING_GENERATOR)).with(new Attribute[]{AttributeUpgradeSupport.MUFFLING_ONLY})).withComputerSupport("gasBurningGenerator")).replace(new Attribute[]{Attributes.ACTIVE_MELT_LIGHT})).build();
    public static final Generator<TileEntityAdvancedSolarGenerator> ADVANCED_SOLAR_GENERATOR = (Generator)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)((Generator.GeneratorBuilder)Generator.GeneratorBuilder.createGenerator(() -> GeneratorsTileEntityTypes.ADVANCED_SOLAR_GENERATOR, GeneratorsLang.DESCRIPTION_ADVANCED_SOLAR_GENERATOR).withGui(() -> GeneratorsContainerTypes.ADVANCED_SOLAR_GENERATOR)).withEnergyConfig((LongSupplier)MekanismGeneratorsConfig.storageConfig.advancedSolarGenerator)).withCustomShape(BlockShapes.ADVANCED_SOLAR_GENERATOR)).withSound(GeneratorsSounds.SOLAR_GENERATOR)).with(new Attribute[]{AttributeUpgradeSupport.MUFFLING_ONLY})).withBounding(new AttributeHasBounding.HandleBoundingBlock(){

        public <DATA> boolean handle(Level level, BlockPos pos, BlockState state, DATA data, AttributeHasBounding.TriBooleanFunction<Level, BlockPos, DATA> consumer) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.getX(), pos.getY() + 1, pos.getZ());
            if (!consumer.accept((Object)level, (Object)mutable, data)) {
                return false;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    mutable.setWithOffset((Vec3i)pos, x, 2, z);
                    if (consumer.accept((Object)level, (Object)mutable, data)) continue;
                    return false;
                }
            }
            return true;
        }
    })).withComputerSupport("advancedSolarGenerator")).replace(new Attribute[]{Attributes.ACTIVE})).build();
    public static final BlockTypeTile<TileEntityTurbineCasing> TURBINE_CASING = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.TURBINE_CASING, (ILangEntry)GeneratorsLang.DESCRIPTION_TURBINE_CASING).withGui(() -> GeneratorsContainerTypes.INDUSTRIAL_TURBINE, (ILangEntry)GeneratorsLang.TURBINE).externalMultiblock()).build();
    public static final BlockTypeTile<TileEntityTurbineValve> TURBINE_VALVE = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.TURBINE_VALVE, (ILangEntry)GeneratorsLang.DESCRIPTION_TURBINE_VALVE).withGui(() -> GeneratorsContainerTypes.INDUSTRIAL_TURBINE, (ILangEntry)GeneratorsLang.TURBINE).with(new Attribute[]{Attributes.COMPARATOR})).externalMultiblock()).withComputerSupport("turbineValve")).build();
    public static final BlockTypeTile<TileEntityTurbineVent> TURBINE_VENT = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.TURBINE_VENT, (ILangEntry)GeneratorsLang.DESCRIPTION_TURBINE_VENT).withGui(() -> GeneratorsContainerTypes.INDUSTRIAL_TURBINE, (ILangEntry)GeneratorsLang.TURBINE).externalMultiblock()).build();
    public static final BlockTypeTile<TileEntityElectromagneticCoil> ELECTROMAGNETIC_COIL = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.ELECTROMAGNETIC_COIL, (ILangEntry)GeneratorsLang.DESCRIPTION_ELECTROMAGNETIC_COIL).internalMultiblock()).build();
    public static final BlockTypeTile<TileEntityRotationalComplex> ROTATIONAL_COMPLEX = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.ROTATIONAL_COMPLEX, (ILangEntry)GeneratorsLang.DESCRIPTION_ROTATIONAL_COMPLEX).internalMultiblock()).build();
    public static final BlockTypeTile<TileEntitySaturatingCondenser> SATURATING_CONDENSER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.SATURATING_CONDENSER, (ILangEntry)GeneratorsLang.DESCRIPTION_SATURATING_CONDENSER).internalMultiblock()).build();
    public static final BlockTypeTile<TileEntityTurbineRotor> TURBINE_ROTOR = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.TURBINE_ROTOR, (ILangEntry)GeneratorsLang.DESCRIPTION_TURBINE_ROTOR).withCustomShape(BlockShapes.TURBINE_ROTOR)).internalMultiblock()).build();
    public static final BlockTypeTile<TileEntityFissionReactorCasing> FISSION_REACTOR_CASING = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.FISSION_REACTOR_CASING, (ILangEntry)GeneratorsLang.DESCRIPTION_FISSION_REACTOR_CASING).withGui(() -> GeneratorsContainerTypes.FISSION_REACTOR, (ILangEntry)GeneratorsLang.FISSION_REACTOR).withSound(GeneratorsSounds.FISSION_REACTOR).externalMultiblock()).build();
    public static final BlockTypeTile<TileEntityFissionReactorPort> FISSION_REACTOR_PORT = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.FISSION_REACTOR_PORT, (ILangEntry)GeneratorsLang.DESCRIPTION_FISSION_REACTOR_PORT).with(new Attribute[]{new AttributeStateFissionPortMode()})).withGui(() -> GeneratorsContainerTypes.FISSION_REACTOR, (ILangEntry)GeneratorsLang.FISSION_REACTOR).withSound(GeneratorsSounds.FISSION_REACTOR).externalMultiblock()).withComputerSupport("fissionReactorPort")).build();
    public static final BlockTypeTile<TileEntityFissionReactorLogicAdapter> FISSION_REACTOR_LOGIC_ADAPTER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.FISSION_REACTOR_LOGIC_ADAPTER, (ILangEntry)GeneratorsLang.DESCRIPTION_FISSION_REACTOR_LOGIC_ADAPTER).with(new Attribute.TileAttribute[]{new Attributes.AttributeRedstoneEmitter(TileEntityFissionReactorLogicAdapter::getRedstoneLevel)}).with(new Attribute[]{Attributes.REDSTONE})).withGui(() -> GeneratorsContainerTypes.FISSION_REACTOR_LOGIC_ADAPTER).withSound(GeneratorsSounds.FISSION_REACTOR).externalMultiblock()).withComputerSupport("fissionReactorLogicAdapter")).build();
    public static final BlockTypeTile<TileEntityFissionFuelAssembly> FISSION_FUEL_ASSEMBLY = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.FISSION_FUEL_ASSEMBLY, (ILangEntry)GeneratorsLang.DESCRIPTION_FISSION_FUEL_ASSEMBLY).internalMultiblock()).withCustomShape(BlockShapes.FUEL_ASSEMBLY)).build();
    public static final BlockTypeTile<TileEntityControlRodAssembly> CONTROL_ROD_ASSEMBLY = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.CONTROL_ROD_ASSEMBLY, (ILangEntry)GeneratorsLang.DESCRIPTION_CONTROL_ROD_ASSEMBLY).internalMultiblock()).withCustomShape(BlockShapes.CONTROL_ROD_ASSEMBLY)).build();
    public static final BlockTypeTile<TileEntityFusionReactorController> FUSION_REACTOR_CONTROLLER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.FUSION_REACTOR_CONTROLLER, (ILangEntry)GeneratorsLang.DESCRIPTION_FUSION_REACTOR_CONTROLLER).withGui(() -> GeneratorsContainerTypes.FUSION_REACTOR_CONTROLLER, (ILangEntry)GeneratorsLang.FUSION_REACTOR).withSound(GeneratorsSounds.FUSION_REACTOR).with(new Attribute[]{Attributes.ACTIVE, Attributes.INVENTORY})).externalMultiblock()).build();
    public static final BlockTypeTile<TileEntityFusionReactorPort> FUSION_REACTOR_PORT = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.FUSION_REACTOR_PORT, (ILangEntry)GeneratorsLang.DESCRIPTION_FUSION_REACTOR_PORT).with(new Attribute[]{Attributes.ACTIVE})).externalMultiblock()).withComputerSupport("fusionReactorPort")).build();
    public static final BlockTypeTile<TileEntityFusionReactorBlock> FUSION_REACTOR_FRAME = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.FUSION_REACTOR_FRAME, (ILangEntry)GeneratorsLang.DESCRIPTION_FUSION_REACTOR_FRAME).externalMultiblock()).build();
    public static final BlockTypeTile<TileEntityFusionReactorLogicAdapter> FUSION_REACTOR_LOGIC_ADAPTER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.FUSION_REACTOR_LOGIC_ADAPTER, (ILangEntry)GeneratorsLang.DESCRIPTION_FUSION_REACTOR_LOGIC_ADAPTER).withGui(() -> GeneratorsContainerTypes.FUSION_REACTOR_LOGIC_ADAPTER).with(new Attribute.TileAttribute[]{new Attributes.AttributeRedstoneEmitter(TileEntityFusionReactorLogicAdapter::getRedstoneLevel)}).externalMultiblock()).withComputerSupport("fusionReactorLogicAdapter")).build();
    public static final BlockTypeTile<TileEntityLaserFocusMatrix> LASER_FOCUS_MATRIX = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.LASER_FOCUS_MATRIX, (ILangEntry)GeneratorsLang.DESCRIPTION_LASER_FOCUS_MATRIX).with(new Attribute[]{AttributeMultiblock.EXTERNAL, Attributes.AttributeMobSpawn.NEVER})).build();
    public static final BlockTypeTile<TileEntityReactorGlass> REACTOR_GLASS = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> GeneratorsTileEntityTypes.REACTOR_GLASS, (ILangEntry)GeneratorsLang.DESCRIPTION_REACTOR_GLASS).with(new Attribute[]{AttributeMultiblock.STRUCTURAL, Attributes.AttributeMobSpawn.NEVER})).build();

    private GeneratorsBlockTypes() {
    }
}

