/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.block_entity;

import com.folumo.mekanism_lasers.Config;
import com.folumo.mekanism_lasers.Mekanism_lasers;
import com.folumo.mekanism_lasers.common.registry.BlockRegistry;
import java.util.List;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import mekanism.common.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class OreGeneratorBlockEntity
extends TileEntityLaserReceptor {
    private int coolDown = 0;
    public static long energyCap = 64000000L;
    public static long usage = Config.oreGeneratorFabricationCost.getAsLong();
    public static int cooldown = Config.oreGeneratorCooldown.getAsInt();
    public static int numberOfOres = Config.oreGeneratorNumberOfOres.getAsInt();
    private LaserEnergyContainer energyContainer;

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((OreGeneratorBlockEntity)this).getDirection());
        for (int slotX = 0; slotX < 5; ++slotX) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                OutputInventorySlot slot = OutputInventorySlot.at((IContentsListener)listener, (int)(8 + slotX * 18), (int)(16 + slotY * 18));
                builder.addSlot((IInventorySlot)slot);
                slot.setSlotType(ContainerSlotType.NORMAL);
            }
        }
        return builder.build();
    }

    public OreGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockRegistry.ORE_GENERATOR, pos, state);
    }

    public static long getUsage() {
        return usage;
    }

    public static long getEnergyCap() {
        return energyCap;
    }

    public void receiveLaserEnergy(long energy) {
        this.energyContainer.insert(energy, Action.EXECUTE, AutomationType.INTERNAL);
    }

    @NotNull
    public Component getName() {
        return Component.literal((String)"Ore Generator");
    }

    protected void addInitialEnergyContainers(EnergyContainerHelper builder, IContentsListener listener) {
        this.energyContainer = LaserEnergyContainer.create((Predicate)BasicEnergyContainer.notExternal, (Predicate)BasicEnergyContainer.internalOnly, (TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
    }

    public LaserEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    protected boolean onUpdateServer() {
        if (this.coolDown == 0) {
            this.coolDown = 20 * cooldown;
            if (this.energyContainer.getEnergy() >= OreGeneratorBlockEntity.getUsage()) {
                this.generateOres();
            }
        } else {
            --this.coolDown;
        }
        return false;
    }

    private void generateOres() {
        ItemStack drop;
        List inventorySlots = this.getInventorySlots(null);
        long energyPerOre = OreGeneratorBlockEntity.getUsage() / (long)numberOfOres;
        for (int i = 0; i < numberOfOres && (drop = InventoryUtils.insertItem((List)inventorySlots, (ItemStack)OreGeneratorBlockEntity.getRandomDrop(), (Action)Action.EXECUTE, (AutomationType)AutomationType.INTERNAL)).isEmpty(); ++i) {
            this.energyContainer.extract(energyPerOre, Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    private static ItemStack getRandomDrop() {
        HolderSet.Named oreTag = (HolderSet.Named)BuiltInRegistries.BLOCK.getTag(Tags.Blocks.ORES).orElseThrow();
        List blacklist = (List)Config.blacklistedOres.get();
        List<Holder> allowedOres = oreTag.stream().filter(ore -> ore.getKey() != null && !blacklist.contains(ore.getKey().location().toString())).filter(ore -> !ore.is(Mekanism_lasers.ORE_BLACKLIST)).toList();
        if (allowedOres.isEmpty()) {
            throw new IllegalStateException("No ores available to generate!");
        }
        RandomSource randomSource = RandomSource.create();
        Holder randomBlockHolder = allowedOres.get(randomSource.nextInt(allowedOres.size()));
        Block randomBlock = (Block)randomBlockHolder.value();
        return new ItemStack((ItemLike)randomBlock.asItem());
    }
}

