/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete;

import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.RawSuggestion;
import com.mt1006.nbt_ac.utils.Fields;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class NbtSuggestionManager {
    private static final Map<String, NbtSuggestions> suggestionMap = new HashMap<String, NbtSuggestions>();
    public static final Map<Suggestion, CustomSuggestion.Data> dataMap = new IdentityHashMap<Suggestion, CustomSuggestion.Data>();
    public static boolean hasCustomSuggestions = false;
    @Nullable
    private static SuggestionsBuilder oldBuilder = null;
    @Nullable
    private static List<Suggestion> oldSuggestionList = null;
    private static int suggestionListCounter = 0;
    public static final Map<Suggestion, String> subtextMap = new LegacyDataMapWrapper();

    public static void add(String key, NbtSuggestions suggestions) {
        suggestionMap.put(key, suggestions);
    }

    @Nullable
    public static NbtSuggestions get(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return suggestionMap.get(key);
    }

    public static Set<Map.Entry<String, NbtSuggestions>> suggestionSet() {
        return suggestionMap.entrySet();
    }

    public static CompletableFuture<Suggestions> loadFromName(@Nullable String name, String tag, SuggestionsBuilder suggestionsBuilder, boolean suggestPath) {
        if (name != null && (name.equals("block/minecraft:repeating_command_block") || name.equals("block/minecraft:chain_command_block"))) {
            name = "block/minecraft:command_block";
        }
        return NbtSuggestionManager.load(NbtSuggestionManager.get(name), tag, suggestionsBuilder, suggestPath, name, null);
    }

    public static CompletableFuture<Suggestions> loadFromSuggestion(NbtSuggestion suggestion, String tag, SuggestionsBuilder suggestionsBuilder) {
        return NbtSuggestionManager.load(suggestion.subcompound, tag, suggestionsBuilder, false, null, suggestion);
    }

    public static CompletableFuture<Suggestions> load(@Nullable NbtSuggestions suggestions, String tag, SuggestionsBuilder suggestionsBuilder, boolean suggestPath, @Nullable String rootTag, @Nullable NbtSuggestion rootSuggestion) {
        if (!Loader.finished) {
            NbtSuggestionManager.simpleSuggestion("", "[suggestions not loaded]", suggestionsBuilder);
            return suggestionsBuilder.buildFuture();
        }
        String rootName = rootTag != null ? rootTag : (rootSuggestion != null ? rootSuggestion.tag : null);
        CustomTagParser tagParser = new CustomTagParser(tag, suggestPath ? CustomTagParser.Type.PATH : CustomTagParser.Type.COMPOUND);
        SuggestionList suggestionList = tagParser.prepareSuggestionList(suggestions, rootTag);
        CustomTagParser.Suggestion suggestionToShow = tagParser.read(suggestionList, rootSuggestion, rootName);
        return NbtSuggestionManager.finishSuggestions(suggestionList, suggestionsBuilder, suggestionToShow, tagParser.getCursor());
    }

    public static CompletableFuture<Suggestions> finishSuggestions(SuggestionList suggestionList, SuggestionsBuilder suggestionsBuilder, @Nullable CustomTagParser.Suggestion suggestionToShow, int cursor) {
        int maxOffset = suggestionsBuilder.getInput().length();
        int newOffset = suggestionsBuilder.getStart() + cursor;
        if (newOffset > maxOffset) {
            SuggestionsBuilder errorBuilder = suggestionsBuilder.createOffset(maxOffset);
            errorBuilder.suggest("_error");
            return errorBuilder.buildFuture();
        }
        SuggestionsBuilder newSuggestionsBuilder = suggestionsBuilder.createOffset(newOffset);
        if (suggestionToShow == null || suggestionToShow == CustomTagParser.Suggestion.TAG) {
            suggestionList.forEach(s -> s.suggest(newSuggestionsBuilder));
        } else {
            suggestionToShow.suggest(newSuggestionsBuilder);
        }
        return newSuggestionsBuilder.buildFuture();
    }

    public static void simpleSuggestion(String text, String subtext, SuggestionsBuilder suggestionsBuilder) {
        new RawSuggestion(text, subtext).suggest(suggestionsBuilder);
    }

    @Nullable
    public static String getSubtext(Suggestion suggestion) {
        CustomSuggestion.Data data = dataMap.get(suggestion);
        return data != null ? data.subtext : null;
    }

    public static void clearProvided() {
        dataMap.clear();
        subtextMap.clear();
        hasCustomSuggestions = false;
        suggestionListCounter = 0;
    }

    public static void clearIfNeeded(SuggestionsBuilder builder) {
        if (NBTac.loaderInterface.isFabric() || Fields.suggestionsBuilderList == null) {
            return;
        }
        try {
            List suggestionList = (List)Fields.suggestionsBuilderList.get(builder);
            if (!(oldBuilder == null || builder.getInput().equals(oldBuilder.getInput()) && builder.getStart() == oldBuilder.getStart())) {
                NbtSuggestionManager.clearProvided();
            } else if (suggestionList != oldSuggestionList && ++suggestionListCounter >= 6) {
                NbtSuggestionManager.clearProvided();
            }
            oldBuilder = builder;
            oldSuggestionList = suggestionList;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class LegacyDataMapWrapper
    extends HashMap<Suggestion, String> {
        @Override
        public String put(Suggestion key, String value) {
            dataMap.put(key, new CustomSuggestion.Data(value, 0, false));
            return value;
        }

        @Override
        public String remove(Object key) {
            return NbtSuggestionManager.dataMap.remove((Object)key).subtext;
        }
    }
}

