/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.config.gui;

import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.config.gui.ModOptionList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends Screen {
    private final Screen lastScreen;
    private ModOptionList list;
    private Button doneButton;
    private Button resetButton;

    public ConfigScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"nbt_ac.options"));
        this.lastScreen = lastScreen;
    }

    public void init() {
        this.list = new ModOptionList(Minecraft.getInstance(), this.width, this.height - 64, 32, 25, this.font);
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, b -> ConfigScreen.onDonePress(this.lastScreen)).pos(this.width / 2 - 155, this.height - 27).size(150, 20).build();
        this.resetButton = Button.builder((Component)Component.translatable((String)"nbt_ac.options.common.reset_settings"), b -> ConfigScreen.onResetPress(this.list)).pos(this.width / 2 + 5, this.height - 27).size(150, 20).build();
        ModConfig.initWidgets(this.list);
        this.addWidget((GuiEventListener)this.list);
        this.addWidget((GuiEventListener)this.doneButton);
        this.addWidget((GuiEventListener)this.resetButton);
    }

    private static void onDonePress(Screen lastScreen) {
        ModConfig.save();
        Minecraft.getInstance().setScreen(lastScreen);
    }

    private static void onResetPress(ModOptionList list) {
        ModConfig.reset();
        list.updateValues();
    }

    public void onClose() {
        ModConfig.save();
        Minecraft.getInstance().setScreen(this.lastScreen);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.list.render(guiGraphics, mouseX, mouseY, partialTick);
        this.doneButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.resetButton.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }
}

