/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions.selectors;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.DataComponentManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.commands.arguments.item.ItemParser$State"})
public abstract class ItemParserStateMixin {
    @Shadow
    @Final
    private StringReader reader;
    @Shadow
    @Final
    private ItemParser.Visitor visitor;
    @Unique
    private int cursorBeforeItem = -1;
    @Unique
    private int cursorBeforeComponent = -1;
    @Unique
    private final Set<DataComponentType<?>> parsedComponents = new HashSet();
    @Unique
    @Nullable
    private DataComponentType<?> lastAdded = null;

    @Shadow
    public static DataComponentType<?> readComponentType(StringReader reader) throws CommandSyntaxException {
        return null;
    }

    @Inject(method={"readItem"}, at={@At(value="HEAD")})
    private void atReadItem(CallbackInfo ci) {
        this.cursorBeforeItem = this.reader.getCursor();
    }

    @Inject(method={"readComponents"}, at={@At(value="INVOKE", target="Lnet/minecraft/commands/arguments/item/ItemParser$State;readComponentType(Lcom/mojang/brigadier/StringReader;)Lnet/minecraft/core/component/DataComponentType;")})
    private void captureComponentId(CallbackInfo ci) {
        int currentCursor = this.reader.getCursor();
        try {
            DataComponentType<?> componentType = ItemParserStateMixin.readComponentType(this.reader);
            this.parsedComponents.add(componentType);
            this.lastAdded = componentType;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        this.reader.setCursor(currentCursor);
    }

    @Inject(method={"readComponents"}, at={@At(value="INVOKE", target="Lnet/minecraft/commands/arguments/item/ItemParser$State;readComponent(Lnet/minecraft/core/component/DataComponentType;)V")})
    private void atReadComponents(CallbackInfo ci) {
        this.visitor.visitSuggestions(this::suggestComponentData);
        this.cursorBeforeComponent = this.reader.getCursor();
    }

    @Inject(method={"suggestComponentAssignmentOrRemoval"}, at={@At(value="HEAD")}, cancellable=true)
    private void atSuggestComponentAssignment(SuggestionsBuilder suggestionsBuilder, CallbackInfoReturnable<CompletableFuture<Suggestions>> cir) {
        Item item = this.findParsedItem();
        String str = suggestionsBuilder.getRemaining().toLowerCase();
        SuggestionList suggestionList = new SuggestionList();
        DataComponentManager.loadSuggestions(suggestionList, str, this.parsedComponents, item, null, true);
        if (str.isEmpty() || str.equals("!")) {
            suggestionList.addRaw("!", "(remove component)", 80);
        }
        suggestionList.forEach(s -> s.suggest(suggestionsBuilder));
        cir.setReturnValue((Object)suggestionsBuilder.buildFuture());
        cir.cancel();
    }

    @Inject(method={"suggestComponent(Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")}, cancellable=true)
    private void atSuggestComponentRemoval(SuggestionsBuilder suggestionsBuilder, CallbackInfoReturnable<CompletableFuture<Suggestions>> cir) {
        Item item = this.findParsedItem();
        String str = suggestionsBuilder.getRemaining().toLowerCase();
        SuggestionList suggestionList = new SuggestionList();
        DataComponentManager.loadSuggestions(suggestionList, str, this.parsedComponents, item, null, false);
        suggestionList.forEach(s -> s.suggest(suggestionsBuilder));
        cir.setReturnValue((Object)suggestionsBuilder.buildFuture());
        cir.cancel();
    }

    @Unique
    @Nullable
    private ResourceLocation findParsedItemId() {
        if (this.cursorBeforeItem == -1) {
            return null;
        }
        ResourceLocation resLoc = null;
        int currentCursor = this.reader.getCursor();
        this.reader.setCursor(this.cursorBeforeItem);
        try {
            resLoc = ResourceLocation.read((StringReader)this.reader);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        this.reader.setCursor(currentCursor);
        return resLoc;
    }

    @Unique
    @Nullable
    private Item findParsedItem() {
        ResourceLocation resLoc = this.findParsedItemId();
        if (resLoc == null) {
            return null;
        }
        return RegistryUtils.ITEM.get(resLoc);
    }

    @Unique
    private CompletableFuture<Suggestions> suggestComponentData(SuggestionsBuilder suggestionsBuilder) {
        NbtSuggestion component;
        ResourceLocation resLoc = this.lastAdded != null ? RegistryUtils.DATA_COMPONENT_TYPE.getKey(this.lastAdded) : null;
        NbtSuggestion nbtSuggestion = component = resLoc != null ? DataComponentManager.componentMap.get("item/" + String.valueOf(resLoc)) : null;
        if (component == null || this.cursorBeforeComponent == -1) {
            return suggestionsBuilder.buildFuture();
        }
        String tag = this.reader.getString().substring(this.cursorBeforeComponent);
        ResourceLocation itemId = this.findParsedItemId();
        SuggestionList suggestionList = new SuggestionList();
        CustomTagParser tagParser = new CustomTagParser(tag, CustomTagParser.Type.COMPONENT);
        CustomTagParser.Suggestion suggestion = tagParser.read(suggestionList, component, itemId != null ? itemId.toString() : null);
        int cursorShift = this.cursorBeforeComponent + tagParser.getCursor() - suggestionsBuilder.getStart();
        return NbtSuggestionManager.finishSuggestions(suggestionList, suggestionsBuilder, suggestion, cursorShift);
    }
}

