/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.block_entity;

import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class BaseEmcBlockEntity
extends BlockEntity
implements IEmcStorage {
    public static final ICapabilityProvider<BaseEmcBlockEntity, @Nullable Direction, IEmcStorage> EMC_STORAGE_PROVIDER = (blockEntity, context) -> blockEntity;
    private long maximumEMC;
    private long currentEMC;

    protected BaseEmcBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setMaximumEMC(Long.MAX_VALUE);
    }

    public final void setMaximumEMC(@Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long max) {
        this.maximumEMC = max;
        if (this.getStoredEmc() > this.getMaximumEmc()) {
            this.currentEMC = this.getMaximumEmc();
            this.storedEmcChanged();
        }
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getStoredEmc() {
        return this.currentEMC;
    }

    @Override
    public @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long getMaximumEmc() {
        return this.maximumEMC;
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcInsertLimit() {
        return this.getNeededEmc();
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcExtractLimit() {
        return this.getStoredEmc();
    }

    protected boolean canAcceptEmc() {
        return true;
    }

    protected boolean canProvideEmc() {
        return true;
    }

    @Override
    public long extractEmc(long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.insertEmc(-toExtract, action);
        }
        if (this.canProvideEmc()) {
            return this.forceExtractEmc(Math.min(this.getEmcExtractLimit(), toExtract), action);
        }
        return 0L;
    }

    @Override
    public long insertEmc(long toAccept, IEmcStorage.EmcAction action) {
        if (toAccept < 0L) {
            return this.extractEmc(-toAccept, action);
        }
        if (this.canAcceptEmc()) {
            return this.forceInsertEmc(Math.min(this.getEmcInsertLimit(), toAccept), action);
        }
        return 0L;
    }

    protected long forceExtractEmc(long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.forceInsertEmc(-toExtract, action);
        }
        long toRemove = Math.min(this.getStoredEmc(), toExtract);
        if (action.execute()) {
            this.currentEMC -= toRemove;
            this.storedEmcChanged();
        }
        return toRemove;
    }

    protected long forceInsertEmc(long toAccept, IEmcStorage.EmcAction action) {
        if (toAccept < 0L) {
            return this.forceExtractEmc(-toAccept, action);
        }
        long toAdd = Math.min(this.getNeededEmc(), toAccept);
        if (action.execute()) {
            this.currentEMC += toAdd;
            this.storedEmcChanged();
        }
        return toAdd;
    }

    protected void storedEmcChanged() {
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.getStoredEmc() > this.getMaximumEmc()) {
            this.currentEMC = this.getMaximumEmc();
        }
        tag.putLong("emc", this.getStoredEmc());
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.currentEMC = Math.min(tag.getLong("emc"), this.getMaximumEmc());
    }
}

