/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.conversion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMaps;
import java.util.List;
import moze_intel.projecte.api.codec.IPECodecHelper;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.Util;
import net.minecraft.util.ExtraCodecs;

public record CustomConversion(int count, NormalizedSimpleStack output, Object2IntSortedMap<NormalizedSimpleStack> ingredients, boolean propagateTags) {
    private static final CustomConversion INVALID = new CustomConversion(0, null, (Object2IntSortedMap<NormalizedSimpleStack>)Object2IntSortedMaps.emptyMap(), false);
    private static final Codec<Object2IntSortedMap<NormalizedSimpleStack>> INGREDIENT_CODEC = IPECodecHelper.INSTANCE.modifiableMap(IPECodecHelper.INSTANCE.unboundedMap(IPECodecHelper.INSTANCE.nssMapCodec(), Codec.INT.validate(value -> value == 0 ? DataResult.error(() -> "Value must not be zero: " + value) : DataResult.success((Object)value)).optionalFieldOf("amount", (Object)1), (map, nss, amount) -> {
        map.merge(nss, amount, Integer::sum);
        return null;
    }).validate(map -> map.isEmpty() ? DataResult.error(() -> "Map must have contents") : DataResult.success((Object)map)), Object2IntLinkedOpenHashMap::new);
    private static final MapCodec<CustomConversion> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).forGetter(CustomConversion::count), (App)IPECodecHelper.INSTANCE.nssCodec().fieldOf("output").forGetter(CustomConversion::output), (App)INGREDIENT_CODEC.fieldOf("ingredients").forGetter(CustomConversion::ingredients), (App)Codec.BOOL.optionalFieldOf("propagateTags", (Object)false).forGetter(CustomConversion::propagateTags)).apply((Applicative)instance, CustomConversion::new));
    public static final Codec<CustomConversion> CODEC = MAP_CODEC.codec();
    private static final Codec<CustomConversion> OR_INVALID_CODEC = IPECodecHelper.INSTANCE.orElseWithLog(MAP_CODEC, INVALID, () -> "Failed to read conversions: {}").codec();
    public static final Codec<List<CustomConversion>> MODIFIABLE_LIST_CODEC = (Codec)Util.make(() -> {
        Codec listCodec = OR_INVALID_CODEC.listOf();
        return Codec.of((Encoder)listCodec, (Decoder)listCodec.map(list -> (List)list.stream().filter(conversion -> conversion != INVALID).collect(Util.toMutableList())));
    });

    public CustomConversion(int count, NormalizedSimpleStack output, Object2IntSortedMap<NormalizedSimpleStack> ingredients) {
        this(count, output, ingredients, false);
    }

    public CustomConversion {
        NSSTag nssTag;
        propagateTags = propagateTags && output instanceof NSSTag && (nssTag = (NSSTag)output).representsTag();
    }

    public static CustomConversion getFor(int count, NormalizedSimpleStack output, Object2IntMap<NormalizedSimpleStack> ingredients) {
        return new CustomConversion(count, output, (Object2IntSortedMap<NormalizedSimpleStack>)new Object2IntLinkedOpenHashMap(ingredients));
    }

    @Override
    public String toString() {
        return "{" + this.count + " * " + String.valueOf(this.output) + " = " + String.valueOf(this.ingredients) + "}";
    }
}

