/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import moze_intel.projecte.api.conversion.CustomConversionFile;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CustomConversionProvider
implements DataProvider {
    private final Map<ResourceLocation, CustomConversionBuilder> customConversions = new LinkedHashMap<ResourceLocation, CustomConversionBuilder>();
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final PackOutput.PathProvider outputProvider;
    private final String modid;

    protected CustomConversionProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid) {
        this.outputProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "pe_custom_conversions");
        this.lookupProvider = lookupProvider;
        this.modid = modid;
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return ((CompletableFuture)this.lookupProvider.thenApply(registries -> {
            this.customConversions.clear();
            this.addCustomConversions((HolderLookup.Provider)registries);
            return registries;
        })).thenCompose(registries -> CompletableFuture.allOf((CompletableFuture[])this.customConversions.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, CustomConversionFile.CODEC, (Object)((CustomConversionBuilder)entry.getValue()).build(), (Path)this.outputProvider.json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new)));
    }

    protected abstract void addCustomConversions(HolderLookup.Provider var1);

    protected CustomConversionBuilder createConversionBuilder(ResourceLocation id) {
        Objects.requireNonNull(id, "Custom Conversion Builder ID cannot be null.");
        if (this.customConversions.containsKey(id)) {
            throw new RuntimeException("Custom conversion '" + String.valueOf(id) + "' has already been registered.");
        }
        CustomConversionBuilder conversionBuilder = new CustomConversionBuilder();
        this.customConversions.put(id, conversionBuilder);
        return conversionBuilder;
    }

    public final String getName() {
        return "Custom EMC Conversions: " + this.modid;
    }
}

