/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import moze_intel.projecte.api.nss.AbstractDataComponentHolderNSSTag;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public final class NSSFluid
extends AbstractDataComponentHolderNSSTag<Fluid> {
    private static final ResourceKey<Fluid> DEFAULT_KEY = ResourceKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)BuiltInRegistries.FLUID.getDefaultKey());
    public static final MapCodec<NSSFluid> CODEC = NSSFluid.createCodec(BuiltInRegistries.FLUID, false, NSSFluid::new);

    private NSSFluid(@NotNull ResourceLocation resourceLocation, boolean isTag, @NotNull DataComponentPatch componentsPatch) {
        super(resourceLocation, isTag, componentsPatch);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull FluidStack stack) {
        return NSSFluid.createFluid((Holder<Fluid>)stack.getFluidHolder(), stack.getComponentsPatch());
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull Fluid fluid) {
        return NSSFluid.createFluid(fluid, DataComponentPatch.EMPTY);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull Fluid fluid, @NotNull DataComponentPatch componentsPatch) {
        return NSSFluid.createFluid((Holder<Fluid>)fluid.builtInRegistryHolder(), componentsPatch);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull Holder<Fluid> item) {
        return NSSFluid.createFluid(item, DataComponentPatch.EMPTY);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull Holder<Fluid> fluidHolder, @NotNull DataComponentPatch componentsPatch) {
        ResourceKey key = fluidHolder.getKey();
        if (key == null) {
            if (!fluidHolder.isBound()) {
                throw new IllegalArgumentException("Can't make an NSSFluid with an unbound direct holder");
            }
            Optional registryKey = BuiltInRegistries.FLUID.getResourceKey((Object)((Fluid)fluidHolder.value()));
            if (registryKey.isEmpty()) {
                throw new IllegalArgumentException("Can't make an NSSFluid with an unregistered fluid");
            }
            key = (ResourceKey)registryKey.get();
        }
        if (key == DEFAULT_KEY) {
            throw new IllegalArgumentException("Can't make NSSFluid with an empty stack");
        }
        return NSSFluid.createFluid(key.location(), componentsPatch);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull ResourceLocation fluidID) {
        return NSSFluid.createFluid(fluidID, DataComponentPatch.EMPTY);
    }

    @NotNull
    public static NSSFluid createFluid(@NotNull ResourceLocation fluidID, @NotNull DataComponentPatch componentsPatch) {
        return new NSSFluid(fluidID, false, componentsPatch);
    }

    @NotNull
    public static NSSFluid createTag(@NotNull ResourceLocation tagId) {
        return new NSSFluid(tagId, true, DataComponentPatch.EMPTY);
    }

    @NotNull
    public static NSSFluid createTag(@NotNull TagKey<Fluid> tag) {
        return NSSFluid.createTag(tag.location());
    }

    @Override
    @NotNull
    protected Registry<Fluid> getRegistry() {
        return BuiltInRegistries.FLUID;
    }

    protected NSSFluid createNew(Holder<Fluid> fluid) {
        return NSSFluid.createFluid(fluid);
    }

    public MapCodec<NSSFluid> codec() {
        return CODEC;
    }
}

