/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.client;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import mezz.jei.api.runtime.IRecipesGui;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.gui.AbstractCollectorScreen;
import moze_intel.projecte.gameObjs.gui.AbstractCondenserScreen;
import moze_intel.projecte.gameObjs.gui.AlchBagScreen;
import moze_intel.projecte.gameObjs.gui.AlchChestScreen;
import moze_intel.projecte.gameObjs.gui.GUIDMFurnace;
import moze_intel.projecte.gameObjs.gui.GUIEternalDensity;
import moze_intel.projecte.gameObjs.gui.GUIMercurialEye;
import moze_intel.projecte.gameObjs.gui.GUIRMFurnace;
import moze_intel.projecte.gameObjs.gui.GUIRelay;
import moze_intel.projecte.gameObjs.gui.GUITransmutation;
import moze_intel.projecte.gameObjs.gui.PEContainerScreen;
import moze_intel.projecte.gameObjs.items.rings.Arcana;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.gameObjs.sound.MovingSoundSWRG;
import moze_intel.projecte.network.commands.client.DumpMissingEmc;
import moze_intel.projecte.rendering.ChestRenderer;
import moze_intel.projecte.rendering.EntitySpriteRenderer;
import moze_intel.projecte.rendering.LayerYue;
import moze_intel.projecte.rendering.PedestalRenderer;
import moze_intel.projecte.rendering.TransmutationRenderingOverlay;
import moze_intel.projecte.utils.ClientKeyHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.entity.TntRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@Mod(value="projecte", dist={Dist.CLIENT})
public class PEClient {
    public static final ResourceLocation ACTIVE_OVERRIDE = PECore.rl("active");
    public static final ResourceLocation MODE_OVERRIDE = PECore.rl("mode");

    public PEClient(ModContainer container, IEventBus modEventBus) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modEventBus.addListener(this::registerScreens);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::registerKeybindings);
        modEventBus.addListener(this::registerOverlays);
        modEventBus.addListener(this::registerRenderers);
        modEventBus.addListener(this::addLayers);
        NeoForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        NeoForge.EVENT_BUS.addListener(this::registerClientCommands);
    }

    private void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Minecraft mc = Minecraft.getInstance();
        Entity entity = event.getEntity();
        if (entity instanceof EntitySWRGProjectile) {
            EntitySWRGProjectile projectile = (EntitySWRGProjectile)entity;
            if (mc.mouseHandler.isMouseGrabbed()) {
                mc.getSoundManager().play((SoundInstance)new MovingSoundSWRG(projectile, event.getLevel().getRandom()));
            }
        }
    }

    private void registerClientCommands(RegisterClientCommandsEvent event) {
        CommandBuildContext context = event.getBuildContext();
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"projecte").then(DumpMissingEmc.register(context)));
    }

    private void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)PEContainerTypes.RM_FURNACE_CONTAINER.get(), GUIRMFurnace::new);
        event.register((MenuType)PEContainerTypes.DM_FURNACE_CONTAINER.get(), GUIDMFurnace::new);
        event.register((MenuType)PEContainerTypes.CONDENSER_CONTAINER.get(), AbstractCondenserScreen.MK1::new);
        event.register((MenuType)PEContainerTypes.CONDENSER_MK2_CONTAINER.get(), AbstractCondenserScreen.MK2::new);
        event.register((MenuType)PEContainerTypes.ALCH_CHEST_CONTAINER.get(), AlchChestScreen::new);
        event.register((MenuType)PEContainerTypes.ALCH_BAG_CONTAINER.get(), AlchBagScreen::new);
        event.register((MenuType)PEContainerTypes.ETERNAL_DENSITY_CONTAINER.get(), GUIEternalDensity::new);
        event.register((MenuType)PEContainerTypes.TRANSMUTATION_CONTAINER.get(), GUITransmutation::new);
        event.register((MenuType)PEContainerTypes.RELAY_MK1_CONTAINER.get(), GUIRelay.GUIRelayMK1::new);
        event.register((MenuType)PEContainerTypes.RELAY_MK2_CONTAINER.get(), GUIRelay.GUIRelayMK2::new);
        event.register((MenuType)PEContainerTypes.RELAY_MK3_CONTAINER.get(), GUIRelay.GUIRelayMK3::new);
        event.register((MenuType)PEContainerTypes.COLLECTOR_MK1_CONTAINER.get(), AbstractCollectorScreen.MK1::new);
        event.register((MenuType)PEContainerTypes.COLLECTOR_MK2_CONTAINER.get(), AbstractCollectorScreen.MK2::new);
        event.register((MenuType)PEContainerTypes.COLLECTOR_MK3_CONTAINER.get(), AbstractCollectorScreen.MK3::new);
        event.register((MenuType)PEContainerTypes.MERCURIAL_EYE_CONTAINER.get(), GUIMercurialEye::new);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        if (ModList.get().isLoaded("jei")) {
            NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, event -> {
                Screen patt0$temp = event.getCurrentScreen();
                if (patt0$temp instanceof PEContainerScreen) {
                    PEContainerScreen screen = (PEContainerScreen)patt0$temp;
                    if (event.getNewScreen() instanceof IRecipesGui) {
                        screen.switchingToJEI = true;
                    }
                }
            });
        }
        evt.enqueueWork(() -> {
            PEClient.addPropertyOverrides(ACTIVE_OVERRIDE, (stack, level, entity, seed) -> (Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false) != false ? 1.0f : 0.0f, PEItems.GEM_OF_ETERNAL_DENSITY, PEItems.VOID_RING, PEItems.ARCANA_RING, PEItems.ARCHANGEL_SMITE, PEItems.BLACK_HOLE_BAND, PEItems.BODY_STONE, PEItems.HARVEST_GODDESS_BAND, PEItems.IGNITION_RING, PEItems.LIFE_STONE, PEItems.MIND_STONE, PEItems.SOUL_STONE, PEItems.WATCH_OF_FLOWING_TIME, PEItems.ZERO_RING);
            PEClient.addPropertyOverrides(MODE_OVERRIDE, (stack, level, entity, seed) -> ((Arcana.ArcanaMode)stack.getOrDefault(PEDataComponentTypes.ARCANA_MODE, (Object)PEItems.ARCANA_RING.asItem().getDefaultMode())).ordinal(), PEItems.ARCANA_RING);
            PEClient.addPropertyOverrides(MODE_OVERRIDE, (stack, level, entity, seed) -> ((Enum)stack.getOrDefault(PEDataComponentTypes.SWRG_MODE, (Object)PEItems.ARCANA_RING.asItem().getDefaultMode())).ordinal(), PEItems.SWIFTWOLF_RENDING_GALE);
        });
    }

    private void registerKeybindings(RegisterKeyMappingsEvent event) {
        ClientKeyHelper.registerKeyBindings(event);
    }

    private void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, PECore.rl("transmutation_result"), (LayeredDraw.Layer)new TransmutationRenderingOverlay());
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)PEBlockEntityTypes.ALCHEMICAL_CHEST.get(), context -> new ChestRenderer(context, PECore.rl("textures/block/alchemical_chest.png"), PEBlocks.ALCHEMICAL_CHEST));
        event.registerBlockEntityRenderer((BlockEntityType)PEBlockEntityTypes.CONDENSER.get(), context -> new ChestRenderer(context, PECore.rl("textures/block/condenser_mk1.png"), PEBlocks.CONDENSER));
        event.registerBlockEntityRenderer((BlockEntityType)PEBlockEntityTypes.CONDENSER_MK2.get(), context -> new ChestRenderer(context, PECore.rl("textures/block/condenser_mk2.png"), PEBlocks.CONDENSER_MK2));
        event.registerBlockEntityRenderer((BlockEntityType)PEBlockEntityTypes.DARK_MATTER_PEDESTAL.get(), PedestalRenderer::new);
        event.registerEntityRenderer((EntityType)PEEntityTypes.WATER_PROJECTILE.get(), context -> new EntitySpriteRenderer(context, PECore.rl("textures/entity/water_orb.png")));
        event.registerEntityRenderer((EntityType)PEEntityTypes.LAVA_PROJECTILE.get(), context -> new EntitySpriteRenderer(context, PECore.rl("textures/entity/lava_orb.png")));
        event.registerEntityRenderer((EntityType)PEEntityTypes.MOB_RANDOMIZER.get(), context -> new EntitySpriteRenderer(context, PECore.rl("textures/entity/randomizer.png")));
        event.registerEntityRenderer((EntityType)PEEntityTypes.LENS_PROJECTILE.get(), context -> new EntitySpriteRenderer(context, PECore.rl("textures/entity/lens_explosive.png")));
        event.registerEntityRenderer((EntityType)PEEntityTypes.FIRE_PROJECTILE.get(), context -> new EntitySpriteRenderer(context, PECore.rl("textures/entity/fireball.png")));
        event.registerEntityRenderer((EntityType)PEEntityTypes.SWRG_PROJECTILE.get(), context -> new EntitySpriteRenderer(context, PECore.rl("textures/entity/lightning.png")));
        event.registerEntityRenderer((EntityType)PEEntityTypes.NOVA_CATALYST_PRIMED.get(), TntRenderer::new);
        event.registerEntityRenderer((EntityType)PEEntityTypes.NOVA_CATACLYSM_PRIMED.get(), TntRenderer::new);
        event.registerEntityRenderer((EntityType)PEEntityTypes.HOMING_ARROW.get(), TippableArrowRenderer::new);
    }

    private void addLayers(EntityRenderersEvent.AddLayers event) {
        for (PlayerSkin.Model model : event.getSkins()) {
            EntityRenderer entityRenderer = event.getSkin(model);
            if (!(entityRenderer instanceof PlayerRenderer)) continue;
            PlayerRenderer skin = (PlayerRenderer)entityRenderer;
            skin.addLayer((RenderLayer)new LayerYue(skin));
        }
    }

    private static void addPropertyOverrides(ResourceLocation override, ItemPropertyFunction propertyGetter, ItemLike ... itemProviders) {
        for (ItemLike itemProvider : itemProviders) {
            ItemProperties.register((Item)itemProvider.asItem(), (ResourceLocation)override, (ItemPropertyFunction)propertyGetter);
        }
    }
}

