/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMaps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import moze_intel.projecte.api.codec.IPECodecHelper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.impl.codec.PECodecHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;

public final class CustomEMCParser {
    private static final Path CONFIG = ProjectEConfig.CONFIG_DIR.resolve("custom_emc.json");
    public static CustomEMCFile currentEntries;
    private static boolean dirty;

    private static CustomEMCFile createDefault() {
        return new CustomEMCFile((Object2LongSortedMap<NSSItem>)new Object2LongLinkedOpenHashMap(), "Use the in-game commands to edit this file");
    }

    public static void init(HolderLookup.Provider registries) {
        CustomEMCParser.flush(registries);
        if (Files.exists(CONFIG, new LinkOption[0])) {
            currentEntries = PECodecHelper.readFromFile(registries, CONFIG, CustomEMCFile.CODEC, "custom emc").orElseGet(CustomEMCParser::createDefault);
        } else {
            currentEntries = CustomEMCParser.createDefault();
            PECodecHelper.writeToFile(registries, CONFIG, CustomEMCFile.CODEC, currentEntries, "default custom EMC");
        }
    }

    public static void addToFile(NSSItem toAdd, long emc) {
        if (emc < 0L) {
            throw new IllegalArgumentException("EMC must be non-negative: " + emc);
        }
        long old = currentEntries.entries().put((Object)toAdd, emc);
        if (old == -1L || old != emc) {
            dirty = true;
        }
    }

    public static boolean removeFromFile(NSSItem toRemove) {
        boolean removed;
        boolean bl = removed = currentEntries.entries().removeLong((Object)toRemove) != -1L;
        if (removed) {
            dirty = true;
        }
        return removed;
    }

    public static void flush(HolderLookup.Provider registries) {
        if (dirty) {
            PECodecHelper.writeToFile(registries, CONFIG, CustomEMCFile.CODEC, currentEntries, "custom EMC");
            dirty = false;
        }
    }

    static {
        dirty = false;
    }

    public record CustomEMCFile(Object2LongSortedMap<NSSItem> entries, @Nullable String comment) {
        public static final Codec<CustomEMCFile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.lenientOptionalFieldOf("comment").forGetter(file -> Optional.ofNullable(file.comment)), (App)IPECodecHelper.INSTANCE.modifiableMap(IPECodecHelper.INSTANCE.lenientKeyUnboundedMap(NSSItem.CODEC, IPECodecHelper.INSTANCE.nonNegativeLong().fieldOf("emc")), Object2LongLinkedOpenHashMap::new).fieldOf("entries").forGetter(CustomEMCFile::entries)).apply((Applicative)instance, (comment, entries) -> new CustomEMCFile((Object2LongSortedMap<NSSItem>)entries, comment.orElse(null))));

        public CustomEMCFile(Object2LongSortedMap<NSSItem> entries, @Nullable String comment) {
            if (!(entries instanceof Object2LongSortedMaps.UnmodifiableSortedMap)) {
                entries.defaultReturnValue(-1L);
            }
        }
    }
}

