/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.event.EMCRemapEvent;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.MappingConfig;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.SimpleGraphMapper;
import moze_intel.projecte.emc.arithmetic.HiddenBigFractionArithmetic;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;
import moze_intel.projecte.emc.collector.DumpToFileCollector;
import moze_intel.projecte.emc.collector.LongToBigFractionCollector;
import moze_intel.projecte.emc.components.DataComponentManager;
import moze_intel.projecte.emc.generator.BigFractionToLongGenerator;
import moze_intel.projecte.emc.mappers.TagMapper;
import moze_intel.projecte.emc.pregenerated.PregeneratedEMC;
import moze_intel.projecte.gameObjs.container.TransmutationContainer;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import moze_intel.projecte.network.packets.to_client.SyncEmcPKT;
import moze_intel.projecte.utils.AnnotationHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class EMCMappingHandler {
    private static final List<IEMCMapper<NormalizedSimpleStack, Long>> mappers = new ArrayList<IEMCMapper<NormalizedSimpleStack, Long>>();
    @Nullable
    private static Object2LongMap<ItemInfo> emc;
    private static int loadIndex;

    public static void loadMappers() {
        if (mappers.isEmpty()) {
            mappers.addAll(AnnotationHelper.getEMCMappers());
            mappers.add(new TagMapper());
            MappingConfig.setup(mappers, DataComponentManager.loadProcessors());
        }
    }

    public static void map(ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        EMCMappingHandler.clearEmcMap();
        SimpleGraphMapper mapper = new SimpleGraphMapper(new HiddenBigFractionArithmetic());
        BigFractionToLongGenerator valueGenerator = new BigFractionToLongGenerator(mapper);
        AbstractMappingCollector mappingCollector = new LongToBigFractionCollector(mapper);
        if (MappingConfig.dumpToFile()) {
            mappingCollector = new DumpToFileCollector(ProjectEConfig.CONFIG_DIR.resolve("mapping_dump.json"), mappingCollector);
        }
        boolean usePregenerated = MappingConfig.usePregenerated();
        Path pregeneratedEmcFile = ProjectEConfig.CONFIG_DIR.resolve("pregenerated_emc.json");
        Optional<Object2LongMap<ItemInfo>> readPregeneratedValues = PregeneratedEMC.read((HolderLookup.Provider)registryAccess, pregeneratedEmcFile, usePregenerated);
        if (readPregeneratedValues.isPresent()) {
            int values = EMCMappingHandler.updateEmcValues(readPregeneratedValues.get());
            PECore.debugLog("Loaded {} values from pregenerated EMC File", values);
        } else {
            SimpleGraphMapper.setLogFoundExploits(MappingConfig.logExploits());
            PECore.debugLog("Starting to collect Mappings...", new Object[0]);
            for (IEMCMapper<NormalizedSimpleStack, Long> emcMapper : mappers) {
                if (!MappingConfig.isEnabled(emcMapper)) continue;
                DumpToFileCollector.currentGroupName = emcMapper.getName();
                try {
                    emcMapper.addMappings(mappingCollector, serverResources, registryAccess, resourceManager);
                    PECore.debugLog("Collected Mappings from " + emcMapper.getClass().getName(), new Object[0]);
                }
                catch (Exception e) {
                    PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Exception during Mapping Collection from Mapper {}. PLEASE REPORT THIS! EMC VALUES MIGHT BE INCONSISTENT!", (Object)emcMapper.getClass().getName(), (Object)e);
                }
            }
            DumpToFileCollector.currentGroupName = "NSSHelper";
            PECore.debugLog("Mapping Collection finished", new Object[0]);
            mappingCollector.finishCollection((HolderLookup.Provider)registryAccess);
            PECore.debugLog("Starting to generate Values:", new Object[0]);
            Object2LongMap graphMapperValues = valueGenerator.generateValues();
            PECore.debugLog("Generated Values...", new Object[0]);
            EMCMappingHandler.updateEmcValues(EMCMappingHandler.filterEMCMap(graphMapperValues));
            PECore.debugLog("Filtered Values...", new Object[0]);
            if (usePregenerated && emc != null) {
                PregeneratedEMC.write((HolderLookup.Provider)registryAccess, pregeneratedEmcFile, emc);
                PECore.debugLog("Wrote Pregen-file!", new Object[0]);
            }
        }
        EMCMappingHandler.fireEmcRemapEvent();
    }

    private static void fireEmcRemapEvent() {
        FuelMapper.loadMap();
        ++loadIndex;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                KnowledgeImpl impl;
                IKnowledgeProvider knowledge = (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
                if (knowledge == null) continue;
                if (knowledge instanceof KnowledgeImpl && (impl = (KnowledgeImpl)knowledge).pruneStaleKnowledge()) {
                    knowledge.sync(player);
                    continue;
                }
                if (!(player.containerMenu instanceof TransmutationContainer)) continue;
                PECore.packetHandler().updateTransmutationTargets(player);
            }
        }
        NeoForge.EVENT_BUS.post((Event)new EMCRemapEvent());
    }

    public static int getLoadIndex() {
        return loadIndex;
    }

    private static Object2LongMap<ItemInfo> filterEMCMap(Object2LongMap<NormalizedSimpleStack> map) {
        Object2LongOpenHashMap resultMap = new Object2LongOpenHashMap(map.size());
        ObjectIterator iterator = Object2LongMaps.fastIterator(map);
        while (iterator.hasNext()) {
            NSSItem nssItem;
            ItemInfo info;
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            Object object = entry.getKey();
            if (!(object instanceof NSSItem) || (info = ItemInfo.fromNSS(nssItem = (NSSItem)object)) == null) continue;
            resultMap.put((Object)info, entry.getLongValue());
        }
        return resultMap;
    }

    public static int getEmcMapSize() {
        return emc == null ? 0 : emc.size();
    }

    public static boolean hasEmcValue(@NotNull ItemInfo info) {
        return emc != null && emc.containsKey((Object)info);
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getStoredEmcValue(@NotNull ItemInfo info) {
        return emc == null ? 0L : emc.getLong((Object)info);
    }

    public static void clearEmcMap() {
        emc = null;
        DataComponentManager.updateCachedValues(null);
    }

    public static Set<ItemInfo> getMappedItems() {
        if (emc == null) {
            return new HashSet<ItemInfo>();
        }
        return new HashSet<ItemInfo>((Collection<ItemInfo>)emc.keySet());
    }

    @ApiStatus.Internal
    public static int updateEmcValues(Object2LongMap<ItemInfo> data) {
        emc = data;
        DataComponentManager.updateCachedValues(arg_0 -> emc.getLong(arg_0));
        return emc.size();
    }

    public static SyncEmcPKT createPacketData() {
        return new SyncEmcPKT((Object2LongMap<ItemInfo>)(emc == null ? Object2LongMaps.emptyMap() : Object2LongMaps.unmodifiable(emc)));
    }

    static {
        loadIndex = -1;
    }
}

