/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.arithmetic.IValueArithmetic;
import moze_intel.projecte.api.mapper.generator.IValueGenerator;
import moze_intel.projecte.emc.collector.MappingCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGraphMapper<T, V extends Comparable<V>, A extends IValueArithmetic<V>>
extends MappingCollector<T, V, A>
implements IValueGenerator<T, V> {
    private static final boolean OVERWRITE_FIXED_VALUES = false;
    private final V ZERO;
    private static boolean logFoundExploits = true;

    public SimpleGraphMapper(A arithmetic) {
        super(arithmetic);
        this.ZERO = arithmetic.getZero();
    }

    static void setLogFoundExploits(boolean log) {
        logFoundExploits = log;
    }

    private void addReason(@Nullable Map<T, Object> reasonForChange, T key, Object reason) {
        if (reasonForChange != null) {
            reasonForChange.put(key, reason);
        }
    }

    private boolean updateMapWithMinimum(Map<T, V> m, T key, V value) {
        Comparable stored = (Comparable)m.get(key);
        if (stored == null || stored.compareTo(value) > 0) {
            m.put(key, value);
            return true;
        }
        return false;
    }

    private boolean canOverride(T something, V value) {
        Comparable valueBeforeInherit = (Comparable)this.fixValueBeforeInherit.get(something);
        return valueBeforeInherit == null || valueBeforeInherit.compareTo(value) == 0;
    }

    private boolean canOverrideZero(T something) {
        Comparable valueBeforeInherit = (Comparable)this.fixValueBeforeInherit.get(something);
        return valueBeforeInherit == null || this.arithmetic.isZero(valueBeforeInherit);
    }

    @Override
    public Map<T, V> generateValues() {
        HashMap<@NotNull K, @NotNull V> values = new HashMap();
        @Nullable HashMap<@NotNull Object, @NotNull V> changedValues = new HashMap<Object, V>(this.fixValueBeforeInherit);
        @Nullable HashMap<@NotNull K, @NotNull String> reasonForChange = null;
        if (SimpleGraphMapper.isDebugGraphmapper()) {
            reasonForChange = new HashMap(changedValues.size());
            for (Map.Entry entry : this.fixValueBeforeInherit.entrySet()) {
                reasonForChange.put(entry.getKey(), "fixValueBefore");
            }
        }
        while (changedValues != null && !changedValues.isEmpty()) {
            while (changedValues != null && !changedValues.isEmpty()) {
                HashMap nextChangedValues = null;
                SimpleGraphMapper.debugPrintln("Loop");
                for (Map.Entry entry : changedValues.entrySet()) {
                    Set usesFor;
                    Comparable value;
                    Object key = entry.getKey();
                    if (!this.canOverride(key, value = (Comparable)entry.getValue()) || !this.updateMapWithMinimum(values, key, value)) continue;
                    if (reasonForChange != null) {
                        SimpleGraphMapper.debugFormat("Set Value for {} to {} because {}", key, value, reasonForChange.get(key));
                    }
                    if ((usesFor = (Set)this.usedIn.get(key)) == null) continue;
                    for (MappingCollector.Conversion conversion : usesFor) {
                        Comparable storedValue;
                        Object ingredientValue;
                        Object resultValueConversion;
                        MappingCollector.Conversion oldConversion = (MappingCollector.Conversion)this.overwriteConversion.get(conversion.output);
                        if (oldConversion != null && oldConversion != conversion || !this.arithmetic.isGreaterThanZero(resultValueConversion = conversion.arithmeticForConversion.div(ingredientValue = this.valueForConversion(values, conversion), conversion.outnumber)) && !conversion.arithmeticForConversion.isFree(resultValueConversion) || (storedValue = (Comparable)values.get(conversion.output)) != null && storedValue.compareTo(resultValueConversion) <= 0) continue;
                        if (nextChangedValues == null) {
                            nextChangedValues = new HashMap();
                        }
                        if (!this.updateMapWithMinimum(nextChangedValues, conversion.output, resultValueConversion)) continue;
                        this.addReason(reasonForChange, conversion.output, key);
                    }
                }
                changedValues = nextChangedValues;
            }
            for (Map.Entry entry : this.conversionsFor.entrySet()) {
                Object k = entry.getKey();
                Comparable minConversionValue = null;
                @Nullable Comparable resultValueActual = (Comparable)values.get(k);
                if (resultValueActual != null && this.arithmetic.isZero(resultValueActual)) {
                    resultValueActual = null;
                }
                for (MappingCollector.Conversion conversion : (Set)entry.getValue()) {
                    Object ingredientValue = this.valueForConversion(values, conversion);
                    Object resultValueConversion = conversion.arithmeticForConversion.div(ingredientValue, conversion.outnumber);
                    if ((this.arithmetic.isGreaterThanZero(resultValueConversion) || conversion.arithmeticForConversion.isFree(resultValueConversion)) && (minConversionValue == null || minConversionValue.compareTo(resultValueConversion) > 0)) {
                        minConversionValue = (Comparable)resultValueConversion;
                    }
                    if (!this.arithmetic.isGreaterThanZero(ingredientValue) || !this.isLessThan(resultValueConversion, resultValueActual)) continue;
                    MappingCollector.Conversion oldConversion = (MappingCollector.Conversion)this.overwriteConversion.get(conversion.output);
                    if (oldConversion != null && oldConversion != conversion) {
                        if (!logFoundExploits) continue;
                        PECore.LOGGER.warn("EMC Exploit: \"{}\" ingredient cost: {} value of result: {} setValueFromConversion: {}", new Object[]{conversion, ingredientValue, this.valueOrZero(resultValueActual), oldConversion});
                        continue;
                    }
                    if (this.canOverrideZero(k)) {
                        if (SimpleGraphMapper.isDebugGraphmapper()) {
                            SimpleGraphMapper.debugFormat("Setting {} to 0 because result ({}) > cost ({}): {}", k, this.valueOrZero(resultValueActual), ingredientValue, conversion);
                            this.addReason(reasonForChange, conversion.output, "exploit recipe");
                        }
                        if (changedValues == null) {
                            changedValues = new HashMap();
                        }
                        changedValues.put(conversion.output, this.ZERO);
                        continue;
                    }
                    if (!logFoundExploits) continue;
                    PECore.LOGGER.warn("EMC Exploit: ingredients ({}) cost {} but output value is {}", new Object[]{conversion, ingredientValue, this.valueOrZero(resultValueActual)});
                }
                if (minConversionValue != null || resultValueActual == null || !this.arithmetic.isGreaterThanZero(resultValueActual) || !this.canOverrideZero(k)) continue;
                SimpleGraphMapper.debugFormat("Removing Value for {} because it does not have any nonzero-conversions anymore.", k);
                if (changedValues == null) {
                    changedValues = new HashMap();
                }
                changedValues.put(k, this.ZERO);
                this.addReason(reasonForChange, k, "all conversions dead");
            }
        }
        SimpleGraphMapper.debugPrintln("");
        values.putAll(this.fixValueAfterInherit);
        values.entrySet().removeIf(something -> this.arithmetic.isFree((Comparable)something.getValue()));
        return values;
    }

    private V valueOrZero(@Nullable V value) {
        return value == null ? this.ZERO : value;
    }

    private boolean isLessThan(V resultValueConversion, @Nullable V resultValueActual) {
        return resultValueActual == null ? this.arithmetic.isLessThanZero(resultValueConversion) : resultValueConversion.compareTo(resultValueActual) < 0;
    }

    private V valueForConversion(Map<T, V> values, MappingCollector.Conversion conversion) {
        try {
            return this.valueForConversionUnsafe(values, conversion);
        }
        catch (ArithmeticException e) {
            PECore.LOGGER.warn("Could not calculate value for {}: {}", (Object)conversion.toString(), (Object)e.toString());
            return this.ZERO;
        }
        catch (Exception e) {
            PECore.LOGGER.warn("Could not calculate value for {}: {}", new Object[]{conversion.toString(), e, e});
            return this.ZERO;
        }
    }

    private V valueForConversionUnsafe(Map<T, V> values, MappingCollector.Conversion conversion) {
        Object value = conversion.value;
        boolean allIngredientsAreFree = true;
        boolean hasPositiveIngredientValues = false;
        ObjectIterator iterator = Object2IntMaps.fastIterator(conversion.ingredientsWithAmount);
        while (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            Comparable storedValue = (Comparable)values.get(entry.getKey());
            if (storedValue == null) {
                return this.ZERO;
            }
            int amount = entry.getIntValue();
            Comparable ingredientValue = conversion.arithmeticForConversion.mul(amount, (Comparable)storedValue);
            if (this.arithmetic.isZero(ingredientValue)) {
                return this.ZERO;
            }
            Comparable newValue = conversion.arithmeticForConversion.add(value, (Comparable)ingredientValue);
            if (value == newValue && !conversion.arithmeticForConversion.isZero((Comparable)ingredientValue)) continue;
            value = newValue;
            if (this.arithmetic.isGreaterThanZero(ingredientValue) && amount > 0) {
                hasPositiveIngredientValues = true;
            }
            allIngredientsAreFree = false;
        }
        if (allIngredientsAreFree || hasPositiveIngredientValues && this.arithmetic.isLessThanEqualZero(value)) {
            return (V)conversion.arithmeticForConversion.getFree();
        }
        return value;
    }
}

