/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.components.processor;

import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.components.DataComponentProcessor;
import moze_intel.projecte.api.components.IDataComponentProcessor;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.config.PEConfigTranslations;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@DataComponentProcessor
public class DecoratedShieldProcessor
implements IDataComponentProcessor {
    @DataComponentProcessor.Instance
    public static final DecoratedShieldProcessor INSTANCE = new DecoratedShieldProcessor();

    @Override
    public String getName() {
        return PEConfigTranslations.DCP_DECORATED_SHIELD.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.DCP_DECORATED_SHIELD.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.DCP_DECORATED_SHIELD.tooltip();
    }

    @Override
    public final boolean hasPersistentComponents() {
        return true;
    }

    @Override
    public final @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long recalculateEMC(@NotNull ItemInfo info, @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long currentEMC) throws ArithmeticException {
        DyeColor baseColor;
        if (info.getItem().is(Tags.Items.TOOLS_SHIELD) && (baseColor = (DyeColor)info.getOrNull(DataComponents.BASE_COLOR)) != null) {
            long bannerValue;
            ItemStack banner = new ItemStack((ItemLike)BannerBlock.byColor((DyeColor)baseColor));
            BannerPatternLayers patternLayers = (BannerPatternLayers)info.getOrNull(DataComponents.BANNER_PATTERNS);
            if (patternLayers != null && !patternLayers.equals((Object)BannerPatternLayers.EMPTY)) {
                banner.set(DataComponents.BANNER_PATTERNS, (Object)patternLayers);
            }
            if ((bannerValue = IEMCProxy.INSTANCE.getValue(banner)) == 0L) {
                return 0L;
            }
            return Math.addExact(currentEMC, bannerValue);
        }
        return currentEMC;
    }

    @Override
    public final void collectPersistentComponents(@NotNull ItemInfo info, @NotNull DataComponentPatch.Builder builder) {
        DyeColor baseColor;
        if (info.getItem().is(Tags.Items.TOOLS_SHIELD) && (baseColor = (DyeColor)info.getOrNull(DataComponents.BASE_COLOR)) != null) {
            builder.set(DataComponents.BASE_COLOR, (Object)baseColor);
            BannerPatternLayers patternLayers = (BannerPatternLayers)info.getOrNull(DataComponents.BANNER_PATTERNS);
            if (patternLayers != null && !patternLayers.equals((Object)BannerPatternLayers.EMPTY)) {
                builder.set(DataComponents.BANNER_PATTERNS, (Object)patternLayers);
            }
        }
    }
}

