/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.components.processor;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMaps;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.Map;
import java.util.function.ToLongFunction;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.components.DataComponentProcessor;
import moze_intel.projecte.api.components.IComponentProcessorHelper;
import moze_intel.projecte.config.PEConfigTranslations;
import moze_intel.projecte.emc.components.processor.PersistentComponentProcessor;
import moze_intel.projecte.utils.Constants;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@DataComponentProcessor
public class FireworkStarProcessor
extends PersistentComponentProcessor<FireworkExplosion> {
    @DataComponentProcessor.Instance
    public static final FireworkStarProcessor INSTANCE = new FireworkStarProcessor();
    private static final ResourceKey<Item> FIREWORK_STAR = (ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)Items.FIREWORK_STAR).orElseThrow();
    private static final Int2ObjectMap<DyeColor> REVERSE_COLOR_LOOKUP = (Int2ObjectMap)Util.make((Object)new Int2ObjectOpenHashMap(), reverseLookup -> {
        for (DyeColor color : Constants.COLORS) {
            reverseLookup.putIfAbsent(color.getFireworkColor(), (Object)color);
        }
    });
    @NotNull
    private Reference2LongMap<FireworkExplosion.Shape> shapeEmcLookup = Reference2LongMaps.emptyMap();
    private long trailEmc;
    private long twinkleEmc;

    @Override
    public String getName() {
        return PEConfigTranslations.DCP_FIREWORK_STAR.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.DCP_FIREWORK_STAR.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.DCP_FIREWORK_STAR.tooltip();
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long recalculateEMC(@NotNull ItemInfo info, @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long currentEMC, @NotNull FireworkExplosion explosion) throws ArithmeticException {
        IntList fadeColors;
        IntList colors;
        if (explosion.hasTrail() && this.trailEmc == 0L || explosion.hasTwinkle() && this.twinkleEmc == 0L) {
            return 0L;
        }
        FireworkExplosion.Shape shape = explosion.shape();
        if (shape != FireworkExplosion.Shape.SMALL_BALL) {
            long shapeEmc = this.shapeEmcLookup.getLong((Object)shape);
            if (shapeEmc == 0L) {
                return 0L;
            }
            currentEMC = Math.addExact(currentEMC, shapeEmc);
        }
        if (explosion.hasTrail()) {
            currentEMC = Math.addExact(currentEMC, this.trailEmc);
        }
        if (explosion.hasTwinkle()) {
            currentEMC = Math.addExact(currentEMC, this.twinkleEmc);
        }
        if (!(colors = explosion.colors()).isEmpty()) {
            long colorsEmc = this.getUsedDyesEmc(colors);
            if (colorsEmc == 0L) {
                return 0L;
            }
            currentEMC = Math.addExact(currentEMC, colorsEmc);
        }
        if (!(fadeColors = explosion.fadeColors()).isEmpty()) {
            long fadeEmc = this.getUsedDyesEmc(fadeColors);
            if (fadeEmc == 0L) {
                return 0L;
            }
            currentEMC = Math.addExact(currentEMC, fadeEmc);
        }
        return currentEMC;
    }

    private long getUsedDyesEmc(IntList colors) {
        long totalEmc = 0L;
        IntListIterator iterator = colors.iterator();
        while (iterator.hasNext()) {
            int color = iterator.nextInt();
            DyeColor dyeColor = (DyeColor)REVERSE_COLOR_LOOKUP.get(color);
            if (dyeColor == null) {
                return 0L;
            }
            long dyeEmc = IComponentProcessorHelper.INSTANCE.getColorEmc(dyeColor);
            if (dyeEmc == 0L) {
                return 0L;
            }
            totalEmc = Math.addExact(totalEmc, dyeEmc);
        }
        return totalEmc;
    }

    @Override
    public void updateCachedValues(@Nullable ToLongFunction<ItemInfo> emcLookup) {
        if (emcLookup == null) {
            this.shapeEmcLookup = Reference2LongMaps.emptyMap();
            this.twinkleEmc = 0L;
            this.trailEmc = 0L;
            return;
        }
        this.shapeEmcLookup = new Reference2LongOpenHashMap(FireworkExplosion.Shape.values().length - 1);
        for (Map.Entry entry : FireworkStarRecipe.SHAPE_BY_ITEM.entrySet()) {
            long emc;
            FireworkExplosion.Shape shape = (FireworkExplosion.Shape)entry.getValue();
            if (shape == FireworkExplosion.Shape.SMALL_BALL || (emc = emcLookup.applyAsLong(ItemInfo.fromItem((ItemLike)entry.getKey()))) <= 0L) continue;
            this.shapeEmcLookup.mergeLong((Object)shape, emc, Math::min);
        }
        this.trailEmc = IComponentProcessorHelper.INSTANCE.getMinEmcFor(emcLookup, FireworkStarRecipe.TRAIL_INGREDIENT);
        this.twinkleEmc = IComponentProcessorHelper.INSTANCE.getMinEmcFor(emcLookup, FireworkStarRecipe.TWINKLE_INGREDIENT);
    }

    @Override
    protected boolean validItem(@NotNull ItemInfo info) {
        return info.getItem().is(FIREWORK_STAR);
    }

    @Override
    protected boolean shouldPersist(@NotNull ItemInfo info, @NotNull FireworkExplosion component) {
        return !component.equals((Object)FireworkExplosion.DEFAULT);
    }

    @Override
    protected DataComponentType<FireworkExplosion> getComponentType(@NotNull ItemInfo info) {
        return DataComponents.FIREWORK_EXPLOSION;
    }
}

