/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.PEConfigTranslations;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.Waxable;

@EMCMapper
public class WaxableMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        Registry blocks = registryAccess.registryOrThrow(Registries.BLOCK);
        NSSItem wax = NSSItem.createItem((ItemLike)Items.HONEYCOMB);
        int recipeCount = 0;
        for (Map.Entry entry : blocks.getDataMap(NeoForgeDataMaps.WAXABLES).entrySet()) {
            Block block = (Block)blocks.get((ResourceKey)entry.getKey());
            if (block == null) continue;
            NSSItem base = NSSItem.createItem((ItemLike)block);
            NSSItem waxed = NSSItem.createItem((ItemLike)((Waxable)entry.getValue()).waxed());
            mapper.addConversion(1, (NormalizedSimpleStack)waxed, EMCHelper.intMapOf(base, 1, wax, 1));
            mapper.addConversion(1, (NormalizedSimpleStack)base, EMCHelper.intMapOf(waxed, 1));
            recipeCount += 2;
        }
        PECore.debugLog("{} Statistics:", this.getName());
        PECore.debugLog("Found {} Waxable Conversions", recipeCount);
    }

    @Override
    public String getName() {
        return PEConfigTranslations.MAPPING_WAXABLE_MAPPER.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.MAPPING_WAXABLE_MAPPER.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.MAPPING_WAXABLE_MAPPER.tooltip();
    }
}

