/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.recipe;

import java.util.Collection;
import java.util.List;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.PEConfigTranslations;
import moze_intel.projecte.emc.mappers.recipe.BaseRecipeTypeMapper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;

@RecipeTypeMapper(priority=-2147483648)
public class FallbackRecipeTypeMapper
extends BaseRecipeTypeMapper {
    @Override
    public String getName() {
        return PEConfigTranslations.MAPPING_CRAFTING_MAPPER_FALLBACK.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.MAPPING_CRAFTING_MAPPER_FALLBACK.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.MAPPING_CRAFTING_MAPPER_FALLBACK.tooltip();
    }

    @Override
    public boolean canHandle(RecipeType<?> recipeType) {
        return true;
    }

    @Override
    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, RecipeHolder<?> recipeHolder, RegistryAccess registryAccess, INSSFakeGroupManager fakeGroupManager) {
        Recipe recipe = recipeHolder.value();
        if (recipe instanceof CraftingRecipe || recipe instanceof AbstractCookingRecipe || recipe instanceof SingleItemRecipe || recipe instanceof SmithingTransformRecipe || recipe instanceof SmithingTrimRecipe) {
            return super.handleRecipe(mapper, recipeHolder, registryAccess, fakeGroupManager);
        }
        return false;
    }

    @Override
    protected Collection<Ingredient> getIngredients(Recipe<?> recipe) {
        Collection<Ingredient> ingredients = super.getIngredients(recipe);
        if (ingredients.isEmpty()) {
            if (recipe instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
                return List.of(transformRecipe.base, transformRecipe.addition, transformRecipe.template);
            }
            if (recipe instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
                return List.of(trimRecipe.base, trimRecipe.addition, trimRecipe.template);
            }
        }
        return ingredients;
    }
}

