/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import java.util.List;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class ToolTipEvent {
    @SubscribeEvent
    public static void tTipEvent(ItemTooltipEvent event) {
        IItemEmcHolder emcHolder;
        long value;
        long value2;
        IPedestalItem pedestalItem;
        ItemStack current = event.getItemStack();
        if (current.isEmpty()) {
            return;
        }
        List tooltip = event.getToolTip();
        if (ProjectEConfig.client.pedestalToolTips.get() && (pedestalItem = (IPedestalItem)current.getCapability(PECapabilities.PEDESTAL_ITEM_CAPABILITY)) != null) {
            tooltip.add(PELang.PEDESTAL_ON.translateColored(ChatFormatting.DARK_PURPLE));
            List<Component> description = pedestalItem.getPedestalDescription(event.getContext().tickRate());
            if (description.isEmpty()) {
                tooltip.add(PELang.PEDESTAL_DISABLED.translateColored(ChatFormatting.RED));
            } else {
                tooltip.addAll(description);
            }
        }
        if (ProjectEConfig.client.tagToolTips.get()) {
            current.getTags().forEach(tag -> tooltip.add(Component.literal((String)("#" + String.valueOf(tag.location())))));
        }
        if (ProjectEConfig.client.emcToolTips.get() && (!ProjectEConfig.client.shiftEmcToolTips.get() || Screen.hasShiftDown()) && (value2 = IEMCProxy.INSTANCE.getValue(current)) > 0L) {
            Player player;
            tooltip.add(EMCHelper.getEmcTextComponent(value2, 1));
            if (current.getCount() > 1) {
                tooltip.add(EMCHelper.getEmcTextComponent(value2, current.getCount()));
            }
            if ((player = event.getEntity()) != null && (!ProjectEConfig.client.shiftLearnedToolTips.get() || Screen.hasShiftDown())) {
                IKnowledgeProvider knowledgeProvider = (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
                if (knowledgeProvider != null && knowledgeProvider.hasKnowledge(current)) {
                    tooltip.add(PELang.EMC_HAS_KNOWLEDGE.translateColored(ChatFormatting.YELLOW));
                } else {
                    tooltip.add(PELang.EMC_NO_KNOWLEDGE.translateColored(ChatFormatting.RED));
                }
            }
        }
        if ((value = ((Long)current.getOrDefault(PEDataComponentTypes.STORED_EMC, (Object)0L)).longValue()) == 0L && (emcHolder = (IItemEmcHolder)current.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY)) != null) {
            value = emcHolder.getStoredEmc(current);
        }
        if (value > 0L) {
            tooltip.add(PELang.EMC_STORED.translateColored(ChatFormatting.YELLOW, ChatFormatting.WHITE, EMCHelper.formatEmc(value)));
        }
    }
}

