/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import java.util.ArrayList;
import moze_intel.projecte.api.block_entity.BaseEmcBlockEntity;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public abstract class EmcBlockEntity
extends BaseEmcBlockEntity {
    private boolean updateComparators;
    private long lastSave;

    public EmcBlockEntity(BlockEntityTypeRegistryObject<? extends EmcBlockEntity> type, BlockPos pos, BlockState state) {
        this(type, pos, state, Long.MAX_VALUE);
    }

    public EmcBlockEntity(BlockEntityTypeRegistryObject<? extends EmcBlockEntity> type, BlockPos pos, BlockState state, @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long maxAmount) {
        super((BlockEntityType)type.get(), pos, state);
        this.setMaximumEMC(maxAmount);
    }

    protected void updateComparators(@NotNull Level level, @NotNull BlockPos pos) {
        if (this.updateComparators) {
            BlockState state = this.getBlockState();
            if (!state.isAir()) {
                level.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
            this.updateComparators = false;
        }
    }

    protected boolean emcAffectsComparators() {
        return false;
    }

    @Override
    protected void storedEmcChanged() {
        if (this.level != null) {
            this.markDirty(this.level, this.worldPosition, this.emcAffectsComparators());
        }
    }

    public final void setChanged() {
        if (this.level != null) {
            this.markDirty(this.level, this.worldPosition, true);
        }
    }

    public void markDirty(@NotNull Level level, @NotNull BlockPos pos, boolean recheckComparators) {
        long time = level.getGameTime();
        if (this.lastSave != time) {
            ChunkAccess chunk = level.getChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()), ChunkStatus.FULL, false);
            if (chunk != null) {
                chunk.setUnsaved(true);
            }
            this.lastSave = time;
        }
        if (recheckComparators && !level.isClientSide) {
            this.updateComparators = true;
        }
    }

    @NotNull
    public final CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long sendToAllAcceptors(@NotNull Level level, BlockPos pos, long emc) {
        if (emc == 0L || !this.canProvideEmc()) {
            return 0L;
        }
        emc = Math.min(this.getEmcExtractLimit(), emc);
        long sentEmc = 0L;
        ArrayList<IEmcStorage> targets = new ArrayList<IEmcStorage>();
        for (Direction dir : Constants.DIRECTIONS) {
            IEmcStorage theirEmcStorage = WorldHelper.getCapability(level, PECapabilities.EMC_STORAGE_CAPABILITY, pos.relative(dir), dir.getOpposite());
            if (theirEmcStorage == null || this.isRelay() && theirEmcStorage.isRelay() || theirEmcStorage.insertEmc(1L, IEmcStorage.EmcAction.SIMULATE) <= 0L) continue;
            targets.add(theirEmcStorage);
        }
        if (!targets.isEmpty()) {
            long emcPer = emc / (long)targets.size();
            for (IEmcStorage target : targets) {
                long emcCanProvide = this.extractEmc(emcPer, IEmcStorage.EmcAction.SIMULATE);
                long acceptedEmc = target.insertEmc(emcCanProvide, IEmcStorage.EmcAction.EXECUTE);
                this.extractEmc(acceptedEmc, IEmcStorage.EmcAction.EXECUTE);
                sentEmc += acceptedEmc;
            }
        }
        return sentEmc;
    }

    protected class CompactableStackHandler
    extends StackHandler {
        private boolean needsCompacting;
        private boolean empty;

        protected CompactableStackHandler(int size) {
            super(size);
            this.needsCompacting = true;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.needsCompacting = true;
        }

        public void compact() {
            if (this.needsCompacting) {
                if (EmcBlockEntity.this.level != null && !((EmcBlockEntity)EmcBlockEntity.this).level.isClientSide) {
                    this.empty = ItemHelper.compactInventory((IItemHandlerModifiable)this);
                }
                this.needsCompacting = false;
            }
        }

        protected void onLoad() {
            super.onLoad();
            this.empty = true;
            int slots = this.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                if (this.getStackInSlot(slot).isEmpty()) continue;
                this.empty = false;
                break;
            }
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }

    protected class StackHandler
    extends ItemStackHandler {
        protected StackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            EmcBlockEntity.this.setChanged();
        }
    }
}

