/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import java.util.List;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.EnumCollectorTier;
import moze_intel.projecte.gameObjs.block_entities.CollectorMK1BlockEntity;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.blocks.PEEntityBlock;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Collector
extends BlockDirection
implements PEEntityBlock<CollectorMK1BlockEntity> {
    private final EnumCollectorTier tier;

    public Collector(EnumCollectorTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
    }

    public EnumCollectorTier getTier() {
        return this.tier;
    }

    @Deprecated
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        CollectorMK1BlockEntity collector = WorldHelper.getBlockEntity(CollectorMK1BlockEntity.class, (BlockGetter)level, pos, true);
        if (collector != null) {
            player.openMenu((MenuProvider)collector, pos);
        }
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        if (ProjectEConfig.client.statToolTips.get()) {
            tooltip.add((Component)PELang.EMC_MAX_GEN_RATE.translateColored(ChatFormatting.DARK_PURPLE, ChatFormatting.BLUE, EMCHelper.formatEmc(this.tier.getGenRate())));
            tooltip.add((Component)PELang.EMC_MAX_STORAGE.translateColored(ChatFormatting.DARK_PURPLE, ChatFormatting.BLUE, EMCHelper.formatEmc(this.tier.getStorage())));
        }
    }

    @Override
    @Nullable
    public BlockEntityTypeRegistryObject<? extends CollectorMK1BlockEntity> getType() {
        return switch (this.tier) {
            default -> throw new MatchException(null, null);
            case EnumCollectorTier.MK1 -> PEBlockEntityTypes.COLLECTOR;
            case EnumCollectorTier.MK2 -> PEBlockEntityTypes.COLLECTOR_MK2;
            case EnumCollectorTier.MK3 -> PEBlockEntityTypes.COLLECTOR_MK3;
        };
    }

    @Deprecated
    public boolean triggerEvent(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, int id, int param) {
        super.triggerEvent(state, level, pos, id, param);
        return this.triggerBlockEntityEvent(state, level, pos, id, param);
    }

    @Deprecated
    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    @Deprecated
    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        CollectorMK1BlockEntity collector = WorldHelper.getBlockEntity(CollectorMK1BlockEntity.class, (BlockGetter)level, pos, true);
        if (collector == null) {
            return super.getAnalogOutputSignal(state, level, pos);
        }
        IItemHandler handler = (IItemHandler)WorldHelper.getCapability(level, Capabilities.ItemHandler.BLOCK, pos, state, collector, Direction.UP);
        if (handler == null) {
            return super.getAnalogOutputSignal(state, level, pos);
        }
        ItemStack charging = handler.getStackInSlot(0);
        if (charging.isEmpty()) {
            return MathUtils.scaleToRedstone(collector.getStoredEmc(), collector.getMaximumEmc());
        }
        IItemEmcHolder emcHolder = (IItemEmcHolder)charging.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
        if (emcHolder != null) {
            return MathUtils.scaleToRedstone(emcHolder.getStoredEmc(charging), emcHolder.getMaximumEmc(charging));
        }
        return MathUtils.scaleToRedstone(collector.getStoredEmc(), collector.getEmcToNextGoal());
    }

    @Override
    @Deprecated
    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            CollectorMK1BlockEntity ent = WorldHelper.getBlockEntity(CollectorMK1BlockEntity.class, (BlockGetter)level, pos);
            if (ent != null) {
                ent.clearLocked();
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

