/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectETNT
extends TntBlock {
    private final TNTEntityCreator tntEntityCreator;

    public ProjectETNT(BlockBehaviour.Properties properties, TNTEntityCreator tntEntityCreator) {
        super(properties);
        this.tntEntityCreator = tntEntityCreator;
    }

    public int getFlammability(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction face) {
        return 100;
    }

    public void onCaughtFire(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @Nullable Direction side, @Nullable LivingEntity igniter) {
        if (!level.isClientSide) {
            this.createAndAddEntity(level, pos, igniter);
            level.gameEvent((Entity)igniter, (Holder)GameEvent.PRIME_FUSE, pos);
        }
    }

    public void createAndAddEntity(@NotNull Level level, @NotNull BlockPos pos, @Nullable LivingEntity igniter) {
        PrimedTnt tnt = this.tntEntityCreator.create(level, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, igniter);
        level.addFreshEntity((Entity)tnt);
        level.playSound(null, tnt.getX(), tnt.getY(), tnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public DispenseItemBehavior createDispenseItemBehavior() {
        return new DefaultDispenseItemBehavior(){

            @NotNull
            protected ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                ProjectETNT.this.createAndAddEntity((Level)source.level(), blockpos, null);
                source.level().gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, blockpos);
                stack.shrink(1);
                return stack;
            }
        };
    }

    public void wasExploded(Level level, @NotNull BlockPos pos, @NotNull Explosion explosion) {
        if (!level.isClientSide) {
            PrimedTnt tnt = this.tntEntityCreator.create(level, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, explosion.getIndirectSourceEntity());
            int fuse = tnt.getFuse();
            tnt.setFuse((int)((short)(level.random.nextInt(fuse / 4) + fuse / 8)));
            level.addFreshEntity((Entity)tnt);
        }
    }

    @FunctionalInterface
    public static interface TNTEntityCreator {
        public PrimedTnt create(Level var1, double var2, double var4, double var6, @Nullable LivingEntity var8);
    }
}

