/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.gameObjs.container.PEHandContainer;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotConsume;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotInput;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotLock;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotOutput;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotUnlearn;
import moze_intel.projecte.gameObjs.items.Tome;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.network.packets.to_server.SearchUpdatePKT;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class TransmutationContainer
extends PEHandContainer {
    private final List<SlotInput> inputSlots = new ArrayList<SlotInput>();
    public final TransmutationInventory transmutationInventory;
    private SlotUnlearn unlearn;

    public static TransmutationContainer fromNetwork(int windowId, Inventory playerInv, FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return new TransmutationContainer(windowId, playerInv, (InteractionHand)buf.readEnum(InteractionHand.class), buf.readByte());
        }
        return new TransmutationContainer(windowId, playerInv);
    }

    public TransmutationContainer(int windowId, Inventory playerInv) {
        super(PEContainerTypes.TRANSMUTATION_CONTAINER, windowId, playerInv, null, 0);
        this.transmutationInventory = new TransmutationInventory(this.playerInv.player);
        this.initSlots();
    }

    public TransmutationContainer(int windowId, Inventory playerInv, InteractionHand hand, int selected) {
        super(PEContainerTypes.TRANSMUTATION_CONTAINER, windowId, playerInv, hand, selected);
        this.transmutationInventory = new TransmutationInventory(this.playerInv.player);
        this.initSlots();
    }

    private void initSlots() {
        this.addSlot((Slot)new SlotInput(this.transmutationInventory, 0, 43, 23));
        this.addSlot((Slot)new SlotInput(this.transmutationInventory, 1, 34, 41));
        this.addSlot((Slot)new SlotInput(this.transmutationInventory, 2, 52, 41));
        this.addSlot((Slot)new SlotInput(this.transmutationInventory, 3, 16, 50));
        this.addSlot((Slot)new SlotInput(this.transmutationInventory, 4, 70, 50));
        this.addSlot((Slot)new SlotInput(this.transmutationInventory, 5, 34, 59));
        this.addSlot((Slot)new SlotInput(this.transmutationInventory, 6, 52, 59));
        this.addSlot((Slot)new SlotInput(this.transmutationInventory, 7, 43, 77));
        this.addSlot((Slot)new SlotLock(this.transmutationInventory, 8, 158, 50));
        this.addSlot((Slot)new SlotConsume(this.transmutationInventory, 9, 107, 97));
        this.unlearn = new SlotUnlearn(this.transmutationInventory, 10, 89, 97);
        this.addSlot((Slot)this.unlearn);
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 11, 158, 9));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 12, 176, 13));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 13, 193, 30));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 14, 199, 50));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 15, 193, 70));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 16, 176, 87));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 17, 158, 91));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 18, 140, 87));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 19, 123, 70));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 20, 116, 50));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 21, 123, 30));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 22, 140, 13));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 23, 158, 31));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 24, 177, 50));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 25, 158, 69));
        this.addSlot((Slot)new SlotOutput(this.transmutationInventory, 26, 139, 50));
        this.addPlayerInventory(35, 117);
    }

    @Override
    @NotNull
    protected Slot addSlot(@NotNull Slot slot) {
        if (slot instanceof SlotInput) {
            SlotInput input = (SlotInput)slot;
            this.inputSlots.add(input);
        }
        return super.addSlot(slot);
    }

    public void removed(@NotNull Player player) {
        ServerPlayer serverPlayer;
        super.removed(player);
        if (!player.isAlive() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasDisconnected()) {
            player.drop(this.unlearn.getItem(), false);
        } else {
            player.getInventory().placeItemBackInInventory(this.unlearn.getItem());
        }
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        if (slotIndex < 9 || slotIndex == 10) {
            return super.quickMoveStack(player, slotIndex);
        }
        Slot currentSlot = this.tryGetSlot(slotIndex);
        if (currentSlot == null || !currentSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        if (slotIndex >= 11 && slotIndex <= 26) {
            ItemStack stack = currentSlot.getItem().copy();
            long itemEmc = IEMCProxy.INSTANCE.getValue(stack);
            if (itemEmc > 0L) {
                stack.setCount(stack.getMaxStackSize());
                int itemsRoomFor = stack.getCount() - ItemHelper.simulateFit((NonNullList<ItemStack>)player.getInventory().items, stack);
                if (itemsRoomFor == 1) {
                    long availableEMC = this.transmutationInventory.getAvailableEmcAsLong();
                    if (itemEmc > availableEMC) {
                        return ItemStack.EMPTY;
                    }
                    if (this.transmutationInventory.isServer()) {
                        this.transmutationInventory.removeEmc(BigInteger.valueOf(itemEmc));
                    }
                    stack.setCount(1);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY)), (ItemStack)stack, (boolean)false);
                } else if (itemsRoomFor > 1) {
                    BigInteger availableEMC = this.transmutationInventory.getAvailableEmc();
                    BigInteger emc = BigInteger.valueOf(itemEmc);
                    BigInteger totalEmc = emc.multiply(BigInteger.valueOf(itemsRoomFor));
                    if (totalEmc.compareTo(availableEMC) > 0) {
                        BigInteger numOperations = availableEMC.divide(emc);
                        itemsRoomFor = numOperations.intValue();
                        totalEmc = emc.multiply(numOperations);
                        if (itemsRoomFor <= 0) {
                            return ItemStack.EMPTY;
                        }
                    }
                    if (this.transmutationInventory.isServer()) {
                        this.transmutationInventory.removeEmc(totalEmc);
                    }
                    stack.setCount(itemsRoomFor);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY)), (ItemStack)stack, (boolean)false);
                }
            }
        } else if (slotIndex > 26) {
            long emc;
            ItemStack slotStack = currentSlot.getItem();
            ItemStack stackToInsert = slotStack;
            if (stackToInsert.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY) != null) {
                stackToInsert = TransmutationContainer.insertItem(this.inputSlots, stackToInsert, true);
                if (slotStack.getCount() == stackToInsert.getCount()) {
                    stackToInsert = TransmutationContainer.insertItem(this.inputSlots, stackToInsert, false);
                }
                if (slotStack.getCount() != stackToInsert.getCount()) {
                    return this.transferSuccess(currentSlot, player, slotStack, stackToInsert);
                }
            }
            if ((emc = IEMCProxy.INSTANCE.getSellValue(stackToInsert)) > 0L || stackToInsert.getItem() instanceof Tome) {
                if (this.transmutationInventory.isServer()) {
                    BigInteger emcBigInt = BigInteger.valueOf(emc);
                    this.transmutationInventory.handleKnowledge(stackToInsert);
                    this.transmutationInventory.addEmc(emcBigInt.multiply(BigInteger.valueOf(stackToInsert.getCount())));
                }
                currentSlot.set(ItemStack.EMPTY);
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void clickPostValidate(int slotIndex, int dragType, @NotNull ClickType clickType, @NotNull Player player) {
        Slot slot;
        if (player.level().isClientSide && this.transmutationInventory.getHandlerForSlot(slotIndex) == this.transmutationInventory.outputs && (slot = this.tryGetSlot(slotIndex)) != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SearchUpdatePKT(this.transmutationInventory.getIndexFromSlot(slotIndex), slot.getItem()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        super.clickPostValidate(slotIndex, dragType, clickType, player);
    }

    public boolean canDragTo(@NotNull Slot slot) {
        return !(slot instanceof SlotConsume) && !(slot instanceof SlotUnlearn) && !(slot instanceof SlotInput) && !(slot instanceof SlotLock) && !(slot instanceof SlotOutput);
    }
}

