/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container.slots.transmutation;

import java.math.BigInteger;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.gameObjs.container.slots.InventoryContainerSlot;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class SlotOutput
extends InventoryContainerSlot {
    private final TransmutationInventory inv;

    public SlotOutput(TransmutationInventory inv, int index, int x, int y) {
        super((IItemHandler)inv, index, x, y);
        this.inv = inv;
    }

    protected void onSwapCraft(int amount) {
        this.remove(amount);
    }

    @NotNull
    public ItemStack remove(int amount) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ItemHelper.size(this.getItem(), amount);
        long emcValue = IEMCProxy.INSTANCE.getValue(stack);
        BigInteger bigEmcValue = BigInteger.valueOf(emcValue);
        if (amount > 1 ? (bigEmcValue = bigEmcValue.multiply(BigInteger.valueOf(amount))).compareTo(this.inv.getAvailableEmc()) > 0 : emcValue > this.inv.getAvailableEmcAsLong()) {
            return ItemStack.EMPTY;
        }
        if (this.inv.isServer()) {
            this.inv.removeEmc(bigEmcValue);
        }
        return stack;
    }

    public void initialize(@NotNull ItemStack stack) {
    }

    public void set(@NotNull ItemStack stack) {
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return false;
    }

    public boolean mayPickup(@NotNull Player player) {
        return !this.hasItem() || IEMCProxy.INSTANCE.getValue(this.getItem()) <= this.inv.getAvailableEmcAsLong();
    }
}

