/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.gameObjs.registries.PERecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class PhiloStoneSmeltingRecipe
extends CustomRecipe {
    public PhiloStoneSmeltingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        return !this.getMatchingRecipes(inv, level).isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registryAccess) {
        Set<RecipeHolder<SmeltingRecipe>> matchingRecipes = this.getMatchingRecipes(inv, (Level)ServerLifecycleHooks.getCurrentServer().overworld());
        if (matchingRecipes.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack output = ((SmeltingRecipe)((RecipeHolder)matchingRecipes.stream().findFirst().get()).value()).getResultItem(registryAccess);
        return output.copyWithCount(output.getCount() * 7);
    }

    private Set<RecipeHolder<SmeltingRecipe>> getMatchingRecipes(CraftingInput inv, @NotNull Level level) {
        ArrayList<ItemStack> philoStones = new ArrayList<ItemStack>();
        ArrayList<ItemStack> coals = new ArrayList<ItemStack>();
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (ItemStack stack : inv.items()) {
            if (stack.isEmpty()) continue;
            allItems.add(stack);
            if (allItems.size() > 9) {
                return Collections.emptySet();
            }
            if (stack.is(PEItems.PHILOSOPHERS_STONE)) {
                philoStones.add(stack);
            }
            if (!stack.is(ItemTags.COALS)) continue;
            coals.add(stack);
        }
        if (allItems.size() == 9) {
            for (ItemStack philoStone : philoStones) {
                for (ItemStack coal : coals) {
                    if (philoStone == coal) continue;
                    HashSet<RecipeHolder<SmeltingRecipe>> matchingRecipes = new HashSet<RecipeHolder<SmeltingRecipe>>();
                    for (ItemStack stack : allItems) {
                        if (stack == philoStone || stack == coal) continue;
                        SingleRecipeInput furnaceInput = new SingleRecipeInput(stack);
                        if (matchingRecipes.isEmpty()) {
                            if (matchingRecipes.addAll(level.getRecipeManager().getRecipesFor(RecipeType.SMELTING, (RecipeInput)furnaceInput, level))) continue;
                            return Collections.emptySet();
                        }
                        Iterator iterator = matchingRecipes.iterator();
                        while (iterator.hasNext()) {
                            RecipeHolder recipe = (RecipeHolder)iterator.next();
                            if (((SmeltingRecipe)recipe.value()).matches(furnaceInput, level)) continue;
                            iterator.remove();
                        }
                        if (!matchingRecipes.isEmpty()) continue;
                        return Collections.emptySet();
                    }
                    if (matchingRecipes.isEmpty()) continue;
                    return matchingRecipes;
                }
            }
        }
        return Collections.emptySet();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 9;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)PERecipeSerializers.PHILO_STONE_SMELTING.get();
    }
}

