/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import moze_intel.projecte.gameObjs.customRecipes.WrappedShapelessRecipe;
import moze_intel.projecte.gameObjs.items.KleinStar;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PERecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;

public class RecipeShapelessKleinStar
extends WrappedShapelessRecipe {
    public RecipeShapelessKleinStar(ShapelessRecipe internal) {
        super(internal);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)PERecipeSerializers.KLEIN.get();
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registryAccess) {
        ItemStack result = this.getInternal().assemble(inv, registryAccess);
        Item item = result.getItem();
        if (item instanceof KleinStar) {
            KleinStar resultingStar = (KleinStar)item;
            long maxEmc = resultingStar.getMaximumEmc(result);
            long storedEMC = 0L;
            for (ItemStack stack : inv.items()) {
                Item item2;
                if (stack.isEmpty() || !((item2 = stack.getItem()) instanceof KleinStar)) continue;
                KleinStar star = (KleinStar)item2;
                long inputEmc = star.getStoredEmc(stack);
                if (inputEmc >= maxEmc - storedEMC) {
                    storedEMC = maxEmc;
                    break;
                }
                storedEMC += inputEmc;
            }
            result.set(PEDataComponentTypes.STORED_EMC, (Object)storedEMC);
        }
        return result;
    }
}

