/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.entity;

import moze_intel.projecte.gameObjs.entity.NoGravityThrowableProjectile;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EntityLavaProjectile
extends NoGravityThrowableProjectile {
    public EntityLavaProjectile(EntityType<EntityLavaProjectile> type, Level level) {
        super(type, level);
    }

    public EntityLavaProjectile(Player entity, Level level) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)PEEntityTypes.LAVA_PROJECTILE.get()), (LivingEntity)entity, level);
    }

    protected void onInsideBlock(@NotNull BlockState state) {
        if (!this.level().isClientSide && state.getFluidState().is(FluidTags.LAVA)) {
            this.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (!level.isClientSide && this.isAlive()) {
            Entity entity = this.getOwner();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                for (BlockPos pos : WorldHelper.positionsAround(this.blockPosition(), 3)) {
                    BlockState state;
                    if (!level.isLoaded(pos) || !(state = level.getBlockState(pos)).getFluidState().is(FluidTags.WATER) || !PlayerHelper.hasEditPermission(player, level, pos = pos.immutable())) continue;
                    WorldHelper.drainFluid(player, level, pos, state);
                    level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
                }
            }
            if (this.getY() > (double)level.getMaxBuildHeight()) {
                LevelData worldInfo = level.getLevelData();
                worldInfo.setRaining(false);
                this.discard();
            }
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        Player player;
        ItemStack found;
        Entity entity;
        super.onHitBlock(result);
        if (!this.level().isClientSide && (entity = this.getOwner()) instanceof Player && !(found = PlayerHelper.findFirstItem(player = (Player)entity, PEItems.VOLCANITE_AMULET)).isEmpty() && ItemPE.consumeFuel(player, found, 32L, true)) {
            WorldHelper.placeFluid(player, this.level(), result.getBlockPos(), result.getDirection(), Fluids.LAVA, false);
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity ent;
        Player player;
        ItemStack found;
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide && (entity = this.getOwner()) instanceof Player && !(found = PlayerHelper.findFirstItem(player = (Player)entity, PEItems.VOLCANITE_AMULET)).isEmpty() && ItemPE.consumeFuel(player, found, 32L, true) && (ent = result.getEntity()).hurt(this.level().damageSources().inFire(), 5.0f)) {
            ent.igniteForSeconds(5.0f);
        }
    }
}

