/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.entity;

import moze_intel.projecte.gameObjs.entity.NoGravityThrowableProjectile;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.EntityRandomizerHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class EntityMobRandomizer
extends NoGravityThrowableProjectile {
    public EntityMobRandomizer(EntityType<EntityMobRandomizer> type, Level level) {
        super(type, level);
    }

    public EntityMobRandomizer(Player entity, Level level) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)PEEntityTypes.MOB_RANDOMIZER.get()), (LivingEntity)entity, level);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide && (entity = result.getEntity()) instanceof Mob) {
            Mob ent = (Mob)entity;
            entity = this.getOwner();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ServerLevel level = (ServerLevel)this.level();
                Mob randomized = EntityRandomizerHelper.getRandomEntity((Level)level, ent);
                if (randomized != null && EMCHelper.consumePlayerFuel(player, 384L) != -1L) {
                    Rabbit rabbit;
                    randomized.moveTo(ent.position(), ent.getYRot(), ent.getXRot());
                    Rabbit.RabbitGroupData data = randomized instanceof Rabbit && (rabbit = (Rabbit)randomized).getVariant() == Rabbit.Variant.EVIL ? new Rabbit.RabbitGroupData(Rabbit.Variant.EVIL) : null;
                    EventHooks.finalizeMobSpawn((Mob)randomized, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(randomized.blockPosition()), (MobSpawnType)MobSpawnType.CONVERSION, data);
                    level.tryAddFreshEntityWithPassengers((Entity)randomized);
                    if (randomized.isAddedToLevel()) {
                        randomized.spawnAnim();
                        ent.discard();
                    }
                }
            }
        }
    }
}

