/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.entity;

import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.NoGravityThrowableProjectile;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public class EntityWaterProjectile
extends NoGravityThrowableProjectile {
    public EntityWaterProjectile(EntityType<EntityWaterProjectile> type, Level level) {
        super(type, level);
    }

    public EntityWaterProjectile(Player entity, Level level) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)PEEntityTypes.WATER_PROJECTILE.get()), (LivingEntity)entity, level);
    }

    protected void onInsideBlock(@NotNull BlockState state) {
        if (!this.level().isClientSide && state.getFluidState().is(FluidTags.WATER)) {
            this.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (!level.isClientSide && this.isAlive()) {
            Entity entity = this.getOwner();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                for (BlockPos pos : WorldHelper.positionsAround(this.blockPosition(), 3)) {
                    BlockState state = level.getBlockState(pos);
                    FluidState fluidState = state.getFluidState();
                    if (!fluidState.is(FluidTags.LAVA)) continue;
                    pos = pos.immutable();
                    if (state.getBlock() instanceof LiquidBlock) {
                        Block block = fluidState.isSource() ? Blocks.OBSIDIAN : Blocks.COBBLESTONE;
                        BlockEvent.FluidPlaceBlockEvent event = new BlockEvent.FluidPlaceBlockEvent((LevelAccessor)level, pos, pos, block.defaultBlockState());
                        if (!((BlockEvent.FluidPlaceBlockEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                            PlayerHelper.checkedPlaceBlock(player, level, pos, event.getNewState());
                        }
                    } else {
                        WorldHelper.drainFluid(player, level, pos, state);
                    }
                    this.playSound(SoundEvents.GENERIC_BURN, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
                }
            }
            if (this.getY() > (double)level.getMaxBuildHeight()) {
                LevelData worldInfo = level.getLevelData();
                worldInfo.setRaining(true);
                this.discard();
            }
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        Entity entity;
        super.onHitBlock(result);
        if (!this.level().isClientSide && (entity = this.getOwner()) instanceof Player) {
            Player player = (Player)entity;
            WorldHelper.placeFluid(player, this.level(), result.getBlockPos(), result.getDirection(), Fluids.WATER, !ProjectEConfig.server.items.opEvertide.get());
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            Entity ent = result.getEntity();
            if (ent.isOnFire()) {
                ent.clearFire();
            }
            ent.push(this.getDeltaMovement().scale(2.0));
        }
    }
}

