/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.container.CondenserContainer;
import moze_intel.projecte.gameObjs.container.CondenserMK2Container;
import moze_intel.projecte.gameObjs.gui.PEContainerScreen;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.TransmutationEMCFormatter;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCondenserScreen<T extends CondenserContainer>
extends PEContainerScreen<T> {
    public AbstractCondenserScreen(T condenser, Inventory playerInventory, Component title) {
        super(condenser, playerInventory, title);
        this.imageWidth = 255;
        this.imageHeight = 233;
    }

    protected abstract ResourceLocation getTexture();

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
        graphics.blit(this.getTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int progress = ((CondenserContainer)this.menu).getProgressScaled();
        graphics.blit(this.getTexture(), this.leftPos + 33, this.topPos + 10, 0, 235, progress, 10);
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int x, int y) {
        long toDisplay = Math.min(((CondenserContainer)this.menu).displayEmc.get(), ((CondenserContainer)this.menu).requiredEmc.get());
        Component emc = TransmutationEMCFormatter.formatEMC(toDisplay);
        graphics.drawString(this.font, emc, 140, 10, 0x404040, false);
    }

    protected void renderTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        long toDisplay = Math.min(((CondenserContainer)this.menu).displayEmc.get(), ((CondenserContainer)this.menu).requiredEmc.get());
        if ((double)toDisplay < 1.0E12) {
            super.renderTooltip(graphics, mouseX, mouseY);
            return;
        }
        int emcLeft = 140 + this.leftPos;
        int emcRight = emcLeft + 110;
        int emcTop = 6 + this.topPos;
        int emcBottom = emcTop + 15;
        if (mouseX > emcLeft && mouseX < emcRight && mouseY > emcTop && mouseY < emcBottom) {
            this.setTooltipForNextRenderPass((Component)PELang.EMC_TOOLTIP.translate(EMCHelper.formatEmc(toDisplay)));
        } else {
            super.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public static class MK2
    extends AbstractCondenserScreen<CondenserMK2Container> {
        public MK2(CondenserMK2Container condenser, Inventory playerInventory, Component title) {
            super(condenser, playerInventory, title);
        }

        @Override
        protected ResourceLocation getTexture() {
            return PECore.rl("textures/gui/condenser_mk2.png");
        }
    }

    public static class MK1
    extends AbstractCondenserScreen<CondenserContainer> {
        public MK1(CondenserContainer condenser, Inventory playerInventory, Component title) {
            super(condenser, playerInventory, title);
        }

        @Override
        protected ResourceLocation getTexture() {
            return PECore.rl("textures/gui/condenser.png");
        }
    }
}

