/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.gui;

import java.math.BigInteger;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.container.TransmutationContainer;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.gameObjs.gui.PEContainerScreen;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.TransmutationEMCFormatter;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GUITransmutation
extends PEContainerScreen<TransmutationContainer> {
    private static final BigInteger MAX_EXACT_TRANSMUTATION_DISPLAY = BigInteger.valueOf(1000000000000L);
    private static final ResourceLocation texture = PECore.rl("textures/gui/transmute.png");
    private final TransmutationInventory inv;
    private EditBox textBoxFilter;
    private Button previous;
    private Button next;

    public GUITransmutation(TransmutationContainer container, Inventory invPlayer, Component title) {
        super(container, invPlayer, title);
        this.inv = container.transmutationInventory;
        this.imageWidth = 228;
        this.imageHeight = 196;
        this.titleLabelX = 6;
        this.titleLabelY = 8;
    }

    @Override
    public void init() {
        super.init();
        this.textBoxFilter = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 83, this.topPos + 8, 55, 10, (Component)Component.empty()));
        this.textBoxFilter.setResponder(this.inv::updateFilter);
        this.previous = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), b -> this.inv.previousPage()).pos(this.leftPos + 125, this.topPos + 100).size(14, 14).build());
        this.next = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), b -> this.inv.nextPage()).pos(this.leftPos + 193, this.topPos + 100).size(14, 14).build());
        this.updateButtons();
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        String filter = this.textBoxFilter.getValue();
        this.init(minecraft, width, height);
        this.textBoxFilter.setValue(filter);
    }

    protected void containerTick() {
        super.containerTick();
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.previous != null) {
            this.previous.active = this.inv.hasPreviousPage();
        }
        if (this.next != null) {
            this.next.active = this.inv.hasNextPage();
        }
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.textBoxFilter.render(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int x, int y) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        graphics.drawString(this.font, (Component)PELang.EMC_TOOLTIP.translate(""), 6, this.imageHeight - 104, 0x404040, false);
        Component emc = TransmutationEMCFormatter.formatEMC(this.inv.getAvailableEmc());
        graphics.drawString(this.font, emc, 6, this.imageHeight - 94, 0x404040, false);
        if (this.inv.learnFlag > 0) {
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_LEARNED_1.translate(), 98, 30, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_LEARNED_2.translate(), 99, 38, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_LEARNED_3.translate(), 100, 46, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_LEARNED_4.translate(), 101, 54, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_LEARNED_5.translate(), 102, 62, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_LEARNED_6.translate(), 103, 70, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_LEARNED_7.translate(), 104, 78, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_LEARNED_8.translate(), 107, 86, 0x404040, false);
            --this.inv.learnFlag;
        }
        if (this.inv.unlearnFlag > 0) {
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_UNLEARNED_1.translate(), 97, 22, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_UNLEARNED_2.translate(), 98, 30, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_UNLEARNED_3.translate(), 99, 38, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_UNLEARNED_4.translate(), 100, 46, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_UNLEARNED_5.translate(), 101, 54, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_UNLEARNED_6.translate(), 102, 62, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_UNLEARNED_7.translate(), 103, 70, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_UNLEARNED_8.translate(), 104, 78, 0x404040, false);
            graphics.drawString(this.font, (Component)PELang.TRANSMUTATION_UNLEARNED_9.translate(), 107, 86, 0x404040, false);
            --this.inv.unlearnFlag;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.textBoxFilter.isFocused()) {
            if (keyCode == 256) {
                this.textBoxFilter.setFocused(false);
                return true;
            }
            return this.textBoxFilter.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (this.textBoxFilter.isMouseOver(x, y)) {
            if (mouseButton == 1) {
                this.textBoxFilter.setValue("");
            }
        } else if (this.textBoxFilter.isFocused() && (this.hoveredSlot == null || !this.hoveredSlot.hasItem() && ((TransmutationContainer)this.menu).getCarried().isEmpty())) {
            this.textBoxFilter.setFocused(false);
        }
        return super.mouseClicked(x, y, mouseButton);
    }

    @Override
    public void removed() {
        super.removed();
        this.inv.learnFlag = 0;
        this.inv.unlearnFlag = 0;
    }

    protected void renderTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        BigInteger emcAmount = this.inv.getAvailableEmc();
        if (emcAmount.compareTo(MAX_EXACT_TRANSMUTATION_DISPLAY) < 0) {
            super.renderTooltip(graphics, mouseX, mouseY);
            return;
        }
        int emcLeft = this.leftPos;
        int emcRight = emcLeft + 82;
        int emcTop = 95 + this.topPos;
        int emcBottom = emcTop + 15;
        if (mouseX > emcLeft && mouseX < emcRight && mouseY > emcTop && mouseY < emcBottom) {
            this.setTooltipForNextRenderPass((Component)PELang.EMC_TOOLTIP.translate(EMCHelper.formatEmc(emcAmount)));
        } else {
            super.renderTooltip(graphics, mouseX, mouseY);
        }
    }
}

