/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DestructionCatalyst
extends ItemPE
implements IItemCharge,
IBarHelper {
    public DestructionCatalyst(Item.Properties props) {
        super(props.component(PEDataComponentTypes.CHARGE, (Object)0).component(PEDataComponentTypes.STORED_EMC, (Object)0L));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = ctx.getItemInHand();
        int numRows = this.calculateDepthFromCharge(stack);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsInBox(WorldHelper.getDeepBox(ctx.getClickedPos(), ctx.getClickedFace(), --numRows))) {
            float hardness;
            BlockState state = level.getBlockState(pos);
            if (state.isAir() || (hardness = state.getDestroySpeed((BlockGetter)level, pos)) == -1.0f || hardness >= 50.0f) continue;
            if (!DestructionCatalyst.consumeFuel(player, stack, 8L, true)) break;
            hasAction = true;
            if (!PlayerHelper.hasBreakPermission((ServerPlayer)player, level, pos = pos.immutable())) continue;
            List list = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, pos), (Entity)player, (ItemStack)stack);
            drops.addAll(list);
            level.removeBlock(pos, false);
            if (level.random.nextInt(8) != 0) continue;
            ((ServerLevel)level).sendParticles((ParticleOptions)(level.random.nextBoolean() ? ParticleTypes.POOF : ParticleTypes.LARGE_SMOKE), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2, 0.0, 0.0, 0.0, 0.05);
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, ctx.getClickedPos());
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.DESTRUCT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.CONSUME;
    }

    protected int calculateDepthFromCharge(ItemStack stack) {
        int charge = this.getCharge(stack);
        if (charge == 0) {
            return 1;
        }
        return (int)Math.pow(2.0, 1 + charge);
    }

    @Override
    public int getNumCharges(@NotNull ItemStack stack) {
        return 3;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }
}

