/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.gameObjs.items.IModeEnum;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IItemMode<MODE extends Enum<MODE>>
extends IModeChanger<MODE> {
    public DataComponentType<MODE> getDataComponentType();

    public MODE getDefaultMode();

    @Override
    default public MODE getMode(@NotNull ItemStack stack) {
        return (MODE)((Enum)stack.getOrDefault(this.getDataComponentType(), this.getDefaultMode()));
    }

    @Override
    default public boolean changeMode(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        Object newMode;
        Object mode = this.getMode(stack);
        if (mode != (newMode = ((IModeEnum)mode).next(stack))) {
            stack.set(this.getDataComponentType(), newMode);
            player.sendSystemMessage((Component)this.getModeSwitchEntry().translate(newMode));
            return true;
        }
        return false;
    }

    default public ILangEntry getModeSwitchEntry() {
        return PELang.MODE_SWITCH;
    }

    default public Component getToolTip(ItemStack stack) {
        return PELang.CURRENT_MODE.translate(ChatFormatting.AQUA, this.getMode(stack));
    }
}

