/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import java.util.List;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class GemChest
extends GemArmorBase
implements IFireProtector {
    public GemChest(Item.Properties props) {
        super(ArmorItem.Type.CHESTPLATE, props);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add((Component)PELang.GEM_LORE_CHEST.translate());
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        Player player;
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (GemChest.isArmorSlot(slot) && !level.isClientSide && entity instanceof Player && PlayerHelper.checkFeedCooldown(player = (Player)entity)) {
            player.getFoodData().eat(2, 10.0f);
            entity.gameEvent((Holder)GameEvent.EAT);
        }
    }

    public static void doExplode(Player player) {
        if (ProjectEConfig.server.difficulty.offensiveAbilities.get()) {
            WorldHelper.createNovaExplosion(player.level(), (Entity)player, player.getX(), player.getY(), player.getZ(), 9.0f);
        }
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, Player player) {
        return player.getItemBySlot(EquipmentSlot.CHEST) == stack;
    }
}

