/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

public class GemFeet
extends GemArmorBase {
    private static final Vec3 VERTICAL_MOVEMENT = new Vec3(0.0, 0.1, 0.0);
    private static final boolean STEP_ASSIST_DEFAULT = false;
    private final Supplier<ItemAttributeModifiers> defaultModifiers = Suppliers.memoize(() -> super.getDefaultAttributeModifiers().withModifierAdded(Attributes.MOVEMENT_SPEED, new AttributeModifier(PECore.rl("armor"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.FEET));
    private final Supplier<ItemAttributeModifiers> defaultWithStepAssistModifiers = Suppliers.memoize(() -> this.getDefaultAttributeModifiers().withModifierAdded(Attributes.STEP_HEIGHT, new AttributeModifier(PECore.rl("gem_step_assist"), 0.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.FEET));

    public GemFeet(Item.Properties props) {
        super(ArmorItem.Type.BOOTS, props.component(PEDataComponentTypes.STEP_ASSIST, (Object)false));
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        return GemFeet.isStepAssist(stack) ? this.defaultWithStepAssistModifiers.get() : super.getDefaultAttributeModifiers(stack);
    }

    public static void toggleStepAssist(ItemStack boots, Player player) {
        boolean oldValue = GemFeet.isStepAssist(boots);
        boots.set(PEDataComponentTypes.STEP_ASSIST, (Object)(!oldValue ? 1 : 0));
        player.sendSystemMessage(GemFeet.getComponent(!oldValue));
    }

    private static boolean isJumpPressed(Player player) {
        if (FMLEnvironment.dist.isClient() && player instanceof LocalPlayer) {
            LocalPlayer clientPlayer = (LocalPlayer)player;
            return clientPlayer.input.jumping;
        }
        return false;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (GemFeet.isArmorSlot(slot) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide) {
                player.resetFallDistance();
            } else {
                boolean flying = player.getAbilities().flying;
                if (!flying && GemFeet.isJumpPressed(player)) {
                    player.addDeltaMovement(VERTICAL_MOVEMENT);
                }
                if (!player.onGround()) {
                    Vec3 deltaMovement = player.getDeltaMovement();
                    if (deltaMovement.y() <= 0.0) {
                        deltaMovement = deltaMovement.multiply(1.0, 0.9, 1.0);
                        player.setDeltaMovement(deltaMovement);
                    }
                    if (!flying) {
                        if (player.zza < 0.0f) {
                            player.setDeltaMovement(deltaMovement.multiply(0.9, 1.0, 0.9));
                        } else if (player.zza > 0.0f && deltaMovement.lengthSqr() < 3.0) {
                            player.setDeltaMovement(deltaMovement.multiply(1.1, 1.0, 1.1));
                        }
                    }
                }
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add((Component)PELang.GEM_LORE_FEET.translate());
        tooltip.add((Component)PELang.STEP_ASSIST_PROMPT.translate(ClientKeyHelper.getKeyName(PEKeybind.BOOTS_TOGGLE)));
        tooltip.add(GemFeet.getComponent(GemFeet.isStepAssist(stack)));
    }

    private static boolean isStepAssist(ItemStack stack) {
        return (Boolean)stack.getOrDefault(PEDataComponentTypes.STEP_ASSIST, (Object)false);
    }

    private static Component getComponent(boolean enabled) {
        if (enabled) {
            return PELang.STEP_ASSIST.translate(ChatFormatting.GREEN, PELang.GEM_ENABLED);
        }
        return PELang.STEP_ASSIST.translate(ChatFormatting.RED, PELang.GEM_DISABLED);
    }
}

