/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public abstract class PEArmor
extends ArmorItem {
    protected PEArmor(Holder<ArmorMaterial> material, ArmorItem.Type armorPiece, Item.Properties props) {
        super(material, armorPiece, props);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return false;
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(@NotNull ItemStack stack, int amount, T entity, @NotNull Consumer<Item> onBroken) {
        return 0;
    }

    public abstract float getFullSetBaseReduction();

    public abstract float getMaxDamageAbsorb(ArmorItem.Type var1, DamageSource var2);

    public ReductionInfo getReductionInfo(DamageSource source) {
        float maxDamageAbsorb = this.getMaxDamageAbsorb(this.type, source);
        float fullSetReduction = this.getFullSetBaseReduction();
        if (maxDamageAbsorb > 0.0f && fullSetReduction > 0.0f) {
            float pieceEffectiveness = this.getPieceEffectiveness(this.type);
            return new ReductionInfo(fullSetReduction * pieceEffectiveness, maxDamageAbsorb * pieceEffectiveness);
        }
        return ReductionInfo.ZERO;
    }

    public float getPieceEffectiveness(ArmorItem.Type type) {
        if (type == ArmorItem.Type.BOOTS || type == ArmorItem.Type.HELMET) {
            return 0.2f;
        }
        if (type == ArmorItem.Type.CHESTPLATE || type == ArmorItem.Type.LEGGINGS) {
            return 0.3f;
        }
        return 0.0f;
    }

    protected static boolean isArmorSlot(int slot) {
        return slot >= 36 && slot < 40;
    }

    public record ReductionInfo(float percentReduced, float maxDamagedAbsorbed) {
        public static final ReductionInfo ZERO = new ReductionInfo(0.0f, 0.0f);

        public ReductionInfo add(ReductionInfo other) {
            if (this == ZERO) {
                return other;
            }
            if (other == ZERO) {
                return this;
            }
            return new ReductionInfo(this.percentReduced + other.percentReduced, this.maxDamagedAbsorbed + other.maxDamagedAbsorbed);
        }
    }
}

