/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.List;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MindStone
extends PEToggleItem
implements IPedestalItem {
    private static final int TRANSFER_RATE = 50;

    public MindStone(Item.Properties props) {
        super(props.component(PEDataComponentTypes.STORED_EXP, (Object)0));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (!level.isClientSide && MindStone.hotBarOrOffHand(slot) && entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue() && this.getXP(player) > 0) {
                int toAdd = Math.min(this.getXP(player), 50);
                this.addStoredXP(stack, toAdd);
                this.removeXP(player, 50);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        int toAdd;
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && !((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue() && this.getStoredXP(stack) != 0 && (toAdd = this.removeStoredXP(stack, 50)) > 0) {
            this.addXP(player, toAdd);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        int storedXp = (Integer)stack.getOrDefault(PEDataComponentTypes.STORED_EXP, (Object)0);
        tooltip.add((Component)PELang.TOOLTIP_STORED_XP.translateColored(ChatFormatting.DARK_GREEN, ChatFormatting.GREEN, String.format("%,d", storedXp)));
    }

    private void removeXP(Player player, int amount) {
        int totalExperience = this.getXP(player) - amount;
        if (totalExperience < 0) {
            player.totalExperience = 0;
            player.experienceLevel = 0;
            player.experienceProgress = 0.0f;
        } else {
            player.totalExperience = totalExperience;
            player.experienceLevel = this.getLvlForXP(totalExperience);
            player.experienceProgress = (float)(totalExperience - this.getXPForLvl(player.experienceLevel)) / (float)player.getXpNeededForNextLevel();
        }
    }

    private void addXP(Player player, int amount) {
        int experiencetotal;
        player.totalExperience = experiencetotal = this.getXP(player) + amount;
        player.experienceLevel = this.getLvlForXP(experiencetotal);
        player.experienceProgress = (float)(experiencetotal - this.getXPForLvl(player.experienceLevel)) / (float)player.getXpNeededForNextLevel();
    }

    private int getXP(Player player) {
        return (int)((float)this.getXPForLvl(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    private int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
    }

    private int getLvlForXP(int totalXP) {
        int result = 0;
        while (this.getXPForLvl(result) <= totalXP) {
            ++result;
        }
        return --result;
    }

    private int getStoredXP(ItemStack stack) {
        return (Integer)stack.getOrDefault(PEDataComponentTypes.STORED_EXP, (Object)0);
    }

    private void setStoredXP(ItemStack stack, int XP) {
        stack.set(PEDataComponentTypes.STORED_EXP, (Object)XP);
    }

    private void addStoredXP(ItemStack stack, int XP) {
        int stored = this.getStoredXP(stack);
        if (stored > Integer.MAX_VALUE - XP) {
            this.setStoredXP(stack, Integer.MAX_VALUE);
        } else {
            this.setStoredXP(stack, stored + XP);
        }
    }

    private int removeStoredXP(ItemStack stack, int XP) {
        int returnResult;
        int result;
        int currentXP = this.getStoredXP(stack);
        if (currentXP < XP) {
            result = 0;
            returnResult = currentXP;
        } else {
            result = currentXP - XP;
            returnResult = XP;
        }
        this.setStoredXP(stack, result);
        return returnResult;
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        boolean sucked = false;
        Vec3 target = pos.getCenter();
        for (ExperienceOrb orb : level.getEntitiesOfClass(ExperienceOrb.class, ((IDMPedestal)pedestal).getEffectBounds())) {
            WorldHelper.gravitateEntityTowards((Entity)orb, target);
            if (level.isClientSide || !(orb.distanceToSqr(target) < 1.21)) continue;
            this.suckXP(orb, stack);
            sucked = true;
        }
        return sucked;
    }

    private void suckXP(ExperienceOrb orb, ItemStack mindStone) {
        long l = this.getStoredXP(mindStone);
        if (l + (long)orb.value > Integer.MAX_VALUE) {
            orb.value = (int)(l + (long)orb.value - Integer.MAX_VALUE);
            this.setStoredXP(mindStone, Integer.MAX_VALUE);
        } else {
            this.addStoredXP(mindStone, orb.value);
            orb.discard();
        }
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        return List.of(PELang.PEDESTAL_MIND_STONE.translateColored(ChatFormatting.BLUE));
    }
}

