/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.List;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.gameObjs.items.GemEternalDensity;
import moze_intel.projecte.gameObjs.items.rings.BlackHoleBand;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class VoidRing
extends GemEternalDensity
implements IPedestalItem,
IExtraFunction {
    public VoidRing(Item.Properties props) {
        super(props);
    }

    @Override
    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        ((BlackHoleBand)PEItems.BLACK_HOLE_BAND.get()).inventoryTick(stack, level, entity, slot, isHeld);
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        return ((BlackHoleBand)PEItems.BLACK_HOLE_BAND.get()).updateInPedestal(stack, level, pos, pedestal);
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        return ((BlackHoleBand)PEItems.BLACK_HOLE_BAND.get()).getPedestalDescription(tickRate);
    }

    @Override
    public boolean doExtraFunction(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        ItemCooldowns cooldowns = player.getCooldowns();
        if (cooldowns.isOnCooldown((Item)this)) {
            return false;
        }
        BlockHitResult lookingAt = PlayerHelper.getBlockLookingAt(player, 64.0);
        BlockPos c = lookingAt.getType() == HitResult.Type.MISS ? BlockPos.containing((Position)PlayerHelper.getLookTarget(player, 32.0)) : lookingAt.getBlockPos();
        EntityTeleportEvent event = new EntityTeleportEvent((Entity)player, (double)c.getX(), (double)c.getY(), (double)c.getZ());
        if (!((EntityTeleportEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            if (player.isPassenger()) {
                player.stopRiding();
            }
            player.resetFallDistance();
            player.teleportTo(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            cooldowns.addCooldown((Item)this, 10);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateInAlchBag(@NotNull IItemHandler inv, @NotNull Player player, @NotNull ItemStack stack) {
        return super.updateInAlchBag(inv, player, stack) | ((BlackHoleBand)PEItems.BLACK_HOLE_BAND.get()).updateInAlchBag(inv, player, stack);
    }

    @Override
    public boolean updateInAlchChest(@NotNull Level level, @NotNull BlockPos pos, @NotNull ItemStack stack) {
        return super.updateInAlchChest(level, pos, stack) | ((BlackHoleBand)PEItems.BLACK_HOLE_BAND.get()).updateInAlchChest(level, pos, stack);
    }
}

