/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.IMatterType;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.IHasConditionalAttributes;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.IModeEnum;
import moze_intel.projecte.gameObjs.items.tools.PETool;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.ToolHelper;
import moze_intel.projecte.utils.text.IHasTranslationKey;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import org.jetbrains.annotations.NotNull;

public class PEKatar
extends PETool
implements IItemMode<KatarMode>,
IExtraFunction,
IHasConditionalAttributes {
    public PEKatar(IMatterType matterType, int numCharges, Item.Properties props) {
        super(matterType, PETags.Blocks.MINEABLE_WITH_PE_KATAR, numCharges, props.attributes(PEKatar.createAttributes((Tier)matterType, (float)19.0f, (float)-2.4f)).component(PEDataComponentTypes.KATAR_MODE, (Object)KatarMode.SLAY_HOSTILE));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add(this.getToolTip(stack));
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility toolAction) {
        return ItemAbilities.DEFAULT_AXE_ACTIONS.contains(toolAction) || ItemAbilities.DEFAULT_SHEARS_ACTIONS.contains(toolAction) || ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(toolAction) || ItemAbilities.DEFAULT_HOE_ACTIONS.contains(toolAction) || ToolHelper.DEFAULT_PE_KATAR_ACTIONS.contains(toolAction);
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        int charge = this.getCharge(stack);
        return target.getBoundingBox().inflate((double)charge, (double)charge / 4.0, (double)charge);
    }

    @Override
    protected float getShortCutDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        float destroySpeed = super.getShortCutDestroySpeed(stack, state);
        if (destroySpeed == 1.0f && state.is(BlockTags.SWORD_EFFICIENT)) {
            return 1.5f;
        }
        return destroySpeed;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(context.getClickedPos());
        return ToolHelper.performActions(context, blockState, ToolHelper.stripLogsAOE(context, blockState, 0L), (ctx, state) -> ToolHelper.scrapeAOE(ctx, state, 0L), (ctx, state) -> ToolHelper.waxOffAOE(ctx, state, 0L), (ctx, state) -> ToolHelper.tillAOE(ctx, state, 0L), (ctx, state) -> {
            if (state.is(BlockTags.LOGS)) {
                return ToolHelper.clearTagAOE(ctx.getLevel(), ctx.getPlayer(), ctx.getHand(), ctx.getItemInHand(), 0L, (TagKey<Block>)BlockTags.LOGS);
            }
            return InteractionResult.PASS;
        }, (ctx, state) -> {
            if (state.is(BlockTags.LEAVES)) {
                return ToolHelper.clearTagAOE(ctx.getLevel(), ctx.getPlayer(), ctx.getHand(), ctx.getItemInHand(), 0L, (TagKey<Block>)BlockTags.LEAVES);
            }
            return InteractionResult.PASS;
        });
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity damaged, @NotNull LivingEntity damager) {
        ToolHelper.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        return ItemHelper.actionResultFromType(ToolHelper.shearEntityAOE(player, hand, 0L), player.getItemInHand(hand));
    }

    @Override
    public boolean doExtraFunction(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        if (player.getAttackStrengthScale(0.0f) == 1.0f) {
            ToolHelper.attackAOE(stack, player, this.getMode(stack) == KatarMode.SLAY_ALL, ProjectEConfig.server.difficulty.katarDeathAura.get(), 0L, hand);
            PlayerHelper.resetCooldown(player);
            return true;
        }
        return false;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity user) {
        return 72000;
    }

    @Override
    public void adjustAttributes(ItemAttributeModifierEvent event) {
        ToolHelper.applyChargeAttributes(event);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = entity.blockPosition();
            Level level = entity.level();
            if (target.isShearable(player, stack, level, pos)) {
                if (!level.isClientSide) {
                    for (ItemStack drop : target.onSheared(player, stack, level, pos)) {
                        target.spawnShearedDrop(level, pos, drop);
                    }
                    entity.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public DataComponentType<KatarMode> getDataComponentType() {
        return (DataComponentType)PEDataComponentTypes.KATAR_MODE.get();
    }

    @Override
    public KatarMode getDefaultMode() {
        return KatarMode.SLAY_HOSTILE;
    }

    public static enum KatarMode implements IModeEnum<KatarMode>
    {
        SLAY_HOSTILE(PELang.MODE_KATAR_1),
        SLAY_ALL(PELang.MODE_KATAR_2);

        public static final Codec<KatarMode> CODEC;
        public static final IntFunction<KatarMode> BY_ID;
        public static final StreamCodec<ByteBuf, KatarMode> STREAM_CODEC;
        private final IHasTranslationKey langEntry;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        private KatarMode(IHasTranslationKey langEntry) {
            this.langEntry = langEntry;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        public KatarMode next(ItemStack stack) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SLAY_ALL;
                case 1 -> SLAY_HOSTILE;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(KatarMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])KatarMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

