/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import java.util.List;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.IMatterType;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.IHasConditionalAttributes;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.tools.PEPickaxe;
import moze_intel.projecte.gameObjs.items.tools.PETool;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.ToolHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import org.jetbrains.annotations.NotNull;

public class PEMorningStar
extends PETool
implements IItemMode<PEPickaxe.PickaxeMode>,
IHasConditionalAttributes {
    public PEMorningStar(IMatterType matterType, int numCharges, Item.Properties props) {
        super(matterType, PETags.Blocks.MINEABLE_WITH_PE_MORNING_STAR, numCharges, props.attributes(PEMorningStar.createAttributes((Tier)matterType, (float)16.0f, (float)-3.0f)).component(PEDataComponentTypes.PICKAXE_MODE, (Object)PEPickaxe.PickaxeMode.STANDARD));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add(this.getToolTip(stack));
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility toolAction) {
        return ItemAbilities.DEFAULT_PICKAXE_ACTIONS.contains(toolAction) || ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(toolAction) || ToolHelper.DEFAULT_PE_HAMMER_ACTIONS.contains(toolAction) || ToolHelper.DEFAULT_PE_MORNING_STAR_ACTIONS.contains(toolAction);
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity damaged, @NotNull LivingEntity damager) {
        ToolHelper.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity living) {
        ToolHelper.digBasedOnMode(stack, level, pos, living, Item::getPlayerPOVHitResult, (PEPickaxe.PickaxeMode)this.getMode(stack));
        return true;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(context.getClickedPos());
        return ToolHelper.performActions(context, blockState, ToolHelper.flattenAOE(context, blockState, 0L), ToolHelper::dowseCampfire, (ctx, state) -> {
            if (state.is(PETags.Blocks.VEIN_SHOVEL)) {
                if (ProjectEConfig.server.items.pickaxeAoeVeinMining.get()) {
                    return ToolHelper.digAOE(ctx.getLevel(), ctx.getPlayer(), ctx.getHand(), ctx.getItemInHand(), ctx.getClickedPos(), ctx.getClickedFace(), false, 0L);
                }
                return ToolHelper.tryVeinMine(ctx.getPlayer(), ctx.getItemInHand(), ctx.getClickedPos(), ctx.getClickedFace());
            }
            return InteractionResult.PASS;
        }, (ctx, state) -> {
            if (state.is(Tags.Blocks.ORES) && !ProjectEConfig.server.items.pickaxeAoeVeinMining.get()) {
                return ToolHelper.tryVeinMine(ctx.getPlayer(), ctx.getItemInHand(), ctx.getClickedPos(), ctx.getClickedFace());
            }
            return InteractionResult.PASS;
        }, (ctx, state) -> ToolHelper.digAOE(ctx.getLevel(), ctx.getPlayer(), ctx.getHand(), ctx.getItemInHand(), ctx.getClickedPos(), ctx.getClickedFace(), !(state.getBlock() instanceof GrassBlock) && !state.is(BlockTags.SAND) && !state.is(BlockTags.DIRT), 0L));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ProjectEConfig.server.items.pickaxeAoeVeinMining.get()) {
            return ItemHelper.actionResultFromType(ToolHelper.mineOreVeinsInAOE(player, hand), stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        return ToolHelper.canMatterMine(this.matterType, state.getBlock()) ? 1200000.0f : super.getDestroySpeed(stack, state) + 48.0f;
    }

    @Override
    public void adjustAttributes(ItemAttributeModifierEvent event) {
        ToolHelper.applyChargeAttributes(event);
    }

    @Override
    public DataComponentType<PEPickaxe.PickaxeMode> getDataComponentType() {
        return (DataComponentType)PEDataComponentTypes.PICKAXE_MODE.get();
    }

    @Override
    public PEPickaxe.PickaxeMode getDefaultMode() {
        return PEPickaxe.PickaxeMode.STANDARD;
    }
}

