/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.IMatterType;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.IModeEnum;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.ToolHelper;
import moze_intel.projecte.utils.text.IHasTranslationKey;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class PEPickaxe
extends PickaxeItem
implements IItemCharge,
IItemMode<PickaxeMode>,
IBarHelper {
    private final IMatterType matterType;
    private final int numCharges;

    public PEPickaxe(IMatterType matterType, int numCharges, Item.Properties props) {
        super((Tier)matterType, props.attributes(PEPickaxe.createAttributes((Tier)matterType, (float)4.0f, (float)-2.8f)).component(PEDataComponentTypes.PICKAXE_MODE, (Object)PickaxeMode.STANDARD).component(PEDataComponentTypes.CHARGE, (Object)0));
        this.matterType = matterType;
        this.numCharges = numCharges;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return false;
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return false;
    }

    public <T extends LivingEntity> int damageItem(@NotNull ItemStack stack, int amount, T entity, @NotNull Consumer<Item> onBroken) {
        return 0;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        if (ToolHelper.canMatterMine(this.matterType, state.getBlock())) {
            return 1200000.0f;
        }
        return ToolHelper.getDestroySpeed(super.getDestroySpeed(stack, state), this.matterType, this.getCharge(stack));
    }

    @Override
    public int getNumCharges(@NotNull ItemStack stack) {
        return this.numCharges;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add(this.getToolTip(stack));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ProjectEConfig.server.items.pickaxeAoeVeinMining.get()) {
            return ItemHelper.actionResultFromType(ToolHelper.mineOreVeinsInAOE(player, hand), stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null || ProjectEConfig.server.items.pickaxeAoeVeinMining.get()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        if (context.getLevel().getBlockState(pos).is(Tags.Blocks.ORES)) {
            return ToolHelper.tryVeinMine(player, context.getItemInHand(), pos, context.getClickedFace());
        }
        return InteractionResult.PASS;
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity living) {
        ToolHelper.digBasedOnMode(stack, level, pos, living, Item::getPlayerPOVHitResult, (PickaxeMode)this.getMode(stack));
        return true;
    }

    @Override
    public DataComponentType<PickaxeMode> getDataComponentType() {
        return (DataComponentType)PEDataComponentTypes.PICKAXE_MODE.get();
    }

    @Override
    public PickaxeMode getDefaultMode() {
        return PickaxeMode.STANDARD;
    }

    public static enum PickaxeMode implements IModeEnum<PickaxeMode>
    {
        STANDARD(PELang.MODE_PICK_1),
        TALLSHOT(PELang.MODE_PICK_2),
        WIDESHOT(PELang.MODE_PICK_3),
        LONGSHOT(PELang.MODE_PICK_4);

        public static final Codec<PickaxeMode> CODEC;
        public static final IntFunction<PickaxeMode> BY_ID;
        public static final StreamCodec<ByteBuf, PickaxeMode> STREAM_CODEC;
        private final IHasTranslationKey langEntry;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        private PickaxeMode(IHasTranslationKey langEntry) {
            this.langEntry = langEntry;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        public PickaxeMode next(ItemStack stack) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> TALLSHOT;
                case 1 -> WIDESHOT;
                case 2 -> LONGSHOT;
                case 3 -> STANDARD;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(PickaxeMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])PickaxeMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

