/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.sound;

import moze_intel.projecte.gameObjs.entity.EntitySWRGProjectile;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class MovingSoundSWRG
extends AbstractTickableSoundInstance {
    private final EntitySWRGProjectile swrgProjectile;
    private float distance = 0.0f;

    public MovingSoundSWRG(EntitySWRGProjectile swrgProjectile, RandomSource random) {
        super((SoundEvent)PESoundEvents.WIND_MAGIC.get(), SoundSource.WEATHER, random);
        this.swrgProjectile = swrgProjectile;
        this.x = this.swrgProjectile.getX();
        this.y = this.swrgProjectile.getY();
        this.z = this.swrgProjectile.getZ();
        this.volume = 0.6f;
    }

    public boolean canPlaySound() {
        return !this.swrgProjectile.isSilent();
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (this.swrgProjectile.isRemoved()) {
            this.stop();
        } else {
            this.x = this.swrgProjectile.getX();
            this.y = this.swrgProjectile.getY();
            this.z = this.swrgProjectile.getZ();
            float f = (float)this.swrgProjectile.getDeltaMovement().horizontalDistance();
            if (f >= 0.01f) {
                this.distance = Mth.clamp((float)(this.distance + 0.0025f), (float)0.0f, (float)1.0f);
                this.volume = Mth.lerp((float)Mth.clamp((float)f, (float)0.0f, (float)0.5f), (float)0.0f, (float)0.7f);
            } else {
                this.distance = 0.0f;
                this.volume = 0.0f;
            }
        }
    }
}

