/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.gameObjs.registries.PEAttachmentTypes;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TransmutationOffline {
    private static final IKnowledgeProvider NOT_FOUND_PROVIDER = TransmutationOffline.immutableView(new KnowledgeImpl.KnowledgeAttachment());
    private static final Map<UUID, IKnowledgeProvider> cachedKnowledgeProviders = new HashMap<UUID, IKnowledgeProvider>();

    public static void cleanAll() {
        cachedKnowledgeProviders.clear();
    }

    public static void clear(UUID playerUUID) {
        cachedKnowledgeProviders.remove(playerUUID);
    }

    static IKnowledgeProvider forPlayer(MinecraftServer server, UUID playerUUID) {
        if (!cachedKnowledgeProviders.containsKey(playerUUID) && !TransmutationOffline.cacheOfflineData(server, playerUUID)) {
            cachedKnowledgeProviders.put(playerUUID, NOT_FOUND_PROVIDER);
        }
        return cachedKnowledgeProviders.get(playerUUID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean cacheOfflineData(MinecraftServer server, UUID playerUUID) {
        if (EffectiveSide.get().isClient()) {
            throw new IllegalStateException("CRITICAL: Trying to read filesystem on client!!");
        }
        Path player = server.getWorldPath(LevelResource.PLAYER_DATA_DIR).resolve(playerUUID.toString() + ".dat");
        if (!Files.exists(player, new LinkOption[0])) return false;
        if (!Files.isRegularFile(player, new LinkOption[0])) return false;
        try (InputStream in = Files.newInputStream(player, new OpenOption[0]);){
            CompoundTag playerDat = NbtIo.readCompressed((InputStream)in, (NbtAccounter)NbtAccounter.unlimitedHeap());
            if (!playerDat.contains("neoforge:attachments", 10)) return false;
            CompoundTag attachmentData = playerDat.getCompound("neoforge:attachments");
            CompoundTag knowledgeData = attachmentData.getCompound(PEAttachmentTypes.KNOWLEDGE.getId().toString());
            RegistryOps serializationContext = server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            DataResult result = KnowledgeImpl.KnowledgeAttachment.CODEC.parse((DynamicOps)serializationContext, (Object)knowledgeData);
            if (result.isSuccess()) {
                cachedKnowledgeProviders.put(playerUUID, TransmutationOffline.immutableView((KnowledgeImpl.KnowledgeAttachment)result.getOrThrow()));
                PECore.debugLog("Caching offline data for UUID: {}", playerUUID);
                boolean bl = true;
                return bl;
            }
            result.ifError(error -> PECore.LOGGER.warn("Failed to cache offline data for API calls for UUID: {}. {}", (Object)playerUUID, (Object)error.message()));
            return false;
        }
        catch (IOException e) {
            PECore.LOGGER.warn("Failed to cache offline data for API calls for UUID: {}", (Object)playerUUID);
        }
        return false;
    }

    private static IKnowledgeProvider immutableView(KnowledgeImpl.KnowledgeAttachment attachment) {
        final IKnowledgeProvider toCopy = KnowledgeImpl.wrapAttachment(attachment);
        return new IKnowledgeProvider(){
            final Set<ItemInfo> immutableKnowledge;
            final IItemHandlerModifiable immutableInputLocks;
            {
                this.immutableKnowledge = Collections.unmodifiableSet(toCopy.getKnowledge());
                this.immutableInputLocks = ItemHelper.immutableCopy(toCopy.getInputAndLocks());
            }

            @Override
            public boolean hasFullKnowledge() {
                return toCopy.hasFullKnowledge();
            }

            @Override
            public void setFullKnowledge(boolean fullKnowledge) {
            }

            @Override
            public void clearKnowledge() {
            }

            @Override
            public boolean hasKnowledge(@NotNull ItemInfo info) {
                return toCopy.hasKnowledge(info);
            }

            @Override
            public boolean addKnowledge(@NotNull ItemInfo info) {
                return false;
            }

            @Override
            public boolean removeKnowledge(@NotNull ItemInfo info) {
                return false;
            }

            @Override
            @NotNull
            public Set<ItemInfo> getKnowledge() {
                return this.immutableKnowledge;
            }

            @Override
            @NotNull
            public IItemHandler getInputAndLocks() {
                return this.immutableInputLocks;
            }

            @Override
            public BigInteger getEmc() {
                return toCopy.getEmc();
            }

            @Override
            public void setEmc(BigInteger emc) {
            }

            @Override
            public void sync(@NotNull ServerPlayer player) {
                toCopy.sync(player);
            }

            @Override
            public void syncEmc(@NotNull ServerPlayer player) {
                toCopy.syncEmc(player);
            }

            @Override
            public void syncKnowledgeChange(@NotNull ServerPlayer player, ItemInfo change, boolean learned) {
                toCopy.syncKnowledgeChange(player, change, learned);
            }

            @Override
            public void syncInputAndLocks(@NotNull ServerPlayer player, IntList slotsChanged, IKnowledgeProvider.TargetUpdateType updateTargets) {
                toCopy.syncInputAndLocks(player, slotsChanged, updateTargets);
            }

            @Override
            public void receiveInputsAndLocks(Int2ObjectMap<ItemStack> changes) {
            }
        };
    }
}

