/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.curios;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import moze_intel.projecte.integration.curios.IExposesCurioAttributes;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public record CurioItemCapability(ItemStack stack) implements ICurio
{
    public ItemStack getStack() {
        return this.stack;
    }

    public void curioTick(SlotContext context) {
        if (!context.cosmetic()) {
            this.getStack().inventoryTick(context.entity().level(), (Entity)context.entity(), 40, false);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id) {
        Item item;
        if (!slotContext.cosmetic() && (item = this.stack.getItem()) instanceof IExposesCurioAttributes) {
            IExposesCurioAttributes exposesCurioAttributes = (IExposesCurioAttributes)item;
            LinkedHashMultimap attributes = LinkedHashMultimap.create();
            exposesCurioAttributes.addAttributes((Multimap<Holder<Attribute>, AttributeModifier>)attributes);
            return attributes;
        }
        return super.getAttributeModifiers(slotContext, id);
    }

    public static void register(RegisterCapabilitiesEvent event, Item item) {
        event.registerItem(CuriosCapability.ITEM, (stack, ctx) -> new CurioItemCapability((ItemStack)stack), new ItemLike[]{item});
    }
}

