/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import moze_intel.projecte.PECore;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;

@EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class ThreadCheckUpdate
extends Thread {
    private static final String curseURL = "https://www.curseforge.com/minecraft/mc-mods/projecte/files";
    private static volatile ComparableVersion target = null;
    private static volatile boolean hasSentMessage = false;

    public ThreadCheckUpdate() {
        this.setName("ProjectE Update Checker Notifier");
    }

    @Override
    public void run() {
        if (!FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.VERSION_CHECK)) {
            return;
        }
        IModInfo info = PECore.MOD_CONTAINER.getModInfo();
        VersionChecker.CheckResult result = null;
        int tries = 0;
        do {
            VersionChecker.CheckResult res;
            if ((res = VersionChecker.getResult((IModInfo)info)).status() != VersionChecker.Status.PENDING) {
                result = res;
            }
            try {
                Thread.sleep(TimeUtil.MILLISECONDS_PER_SECOND);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (result == null && ++tries < 10);
        if (result == null) {
            PECore.LOGGER.warn("Update check failed.");
            return;
        }
        if (result.status() == VersionChecker.Status.OUTDATED) {
            target = result.target();
        }
    }

    @SubscribeEvent
    public static void worldLoad(EntityJoinLevelEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            if (target != null && !hasSentMessage) {
                hasSentMessage = true;
                player.sendSystemMessage((Component)PELang.UPDATE_AVAILABLE.translate(target));
                player.sendSystemMessage((Component)PELang.UPDATE_GET_IT.translate());
                player.sendSystemMessage((Component)TextComponentUtil.build(new ClickEvent(ClickEvent.Action.OPEN_URL, curseURL), curseURL));
            }
        }
    }
}

