/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import moze_intel.projecte.PEPermissions;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.registries.PEAttachmentTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.impl.capability.AlchBagImpl;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.server.command.EnumArgument;
import org.jetbrains.annotations.NotNull;

public class ShowBagCMD {
    private static final SimpleCommandExceptionType NOT_FOUND = new SimpleCommandExceptionType((Message)PELang.SHOWBAG_NOT_FOUND.translate());

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"showbag").requires((Predicate)PEPermissions.COMMAND_SHOW_BAG)).then(((RequiredArgumentBuilder)Commands.argument((String)"color", (ArgumentType)EnumArgument.enumArgument(DyeColor.class)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ctx -> ShowBagCMD.showBag((CommandContext<CommandSourceStack>)ctx, (DyeColor)ctx.getArgument("color", DyeColor.class), EntityArgument.getPlayer((CommandContext)ctx, (String)"target"))))).then(Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).executes(ctx -> ShowBagCMD.showBag((CommandContext<CommandSourceStack>)ctx, (DyeColor)ctx.getArgument("color", DyeColor.class), UuidArgument.getUuid((CommandContext)ctx, (String)"uuid")))));
    }

    private static int showBag(CommandContext<CommandSourceStack> ctx, DyeColor color, ServerPlayer player) throws CommandSyntaxException {
        ServerPlayer senderPlayer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        return ShowBagCMD.showBag(senderPlayer, ShowBagCMD.createContainer(senderPlayer, player, color));
    }

    private static int showBag(CommandContext<CommandSourceStack> ctx, DyeColor color, UUID uuid) throws CommandSyntaxException {
        ServerPlayer senderPlayer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        return ShowBagCMD.showBag(senderPlayer, ShowBagCMD.createContainer(((CommandSourceStack)ctx.getSource()).getServer(), senderPlayer, uuid, color));
    }

    private static int showBag(ServerPlayer senderPlayer, MenuProvider container) {
        senderPlayer.openMenu(container, b -> {
            b.writeBoolean(false);
            b.writeBoolean(false);
        });
        return 1;
    }

    private static MenuProvider createContainer(ServerPlayer sender, ServerPlayer target, DyeColor color) {
        IItemHandlerModifiable inv = (IItemHandlerModifiable)Objects.requireNonNull((IAlchBagProvider)target.getCapability(PECapabilities.ALCH_BAG_CAPABILITY)).getBag(color);
        MutableComponent name = PELang.SHOWBAG_NAMED.translate(new Object[]{PEItems.getBag(color), target.getDisplayName()});
        return ShowBagCMD.getContainer(sender, (Component)name, inv, false, () -> target.isAlive() && !target.hasDisconnected());
    }

    private static MenuProvider createContainer(MinecraftServer server, ServerPlayer sender, UUID target, DyeColor color) throws CommandSyntaxException {
        Optional profileByUUID;
        IItemHandlerModifiable inv = ShowBagCMD.loadOfflineBag(server, target, color);
        Component name = PEItems.getBag(color).getDescription();
        Optional optional = profileByUUID = server.getProfileCache() == null ? Optional.empty() : server.getProfileCache().get(target);
        if (profileByUUID.isPresent()) {
            name = PELang.SHOWBAG_NAMED.translate(name, ((GameProfile)profileByUUID.get()).getName());
        }
        return ShowBagCMD.getContainer(sender, name, inv, true, () -> true);
    }

    private static MenuProvider getContainer(final ServerPlayer sender, final Component name, final IItemHandlerModifiable inv, final boolean immutable, final BooleanSupplier canInteractWith) {
        return new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return name;
            }

            public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInv, @NotNull Player player) {
                return new AlchBagContainer(windowId, sender.getInventory(), InteractionHand.OFF_HAND, inv, 0, immutable){

                    @Override
                    public boolean stillValid(@NotNull Player player) {
                        return canInteractWith.getAsBoolean();
                    }
                };
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IItemHandlerModifiable loadOfflineBag(MinecraftServer server, UUID playerUUID, DyeColor color) throws CommandSyntaxException {
        Path player = server.getWorldPath(LevelResource.PLAYER_DATA_DIR).resolve(playerUUID.toString() + ".dat");
        if (!Files.exists(player, new LinkOption[0])) throw NOT_FOUND.create();
        if (!Files.isRegularFile(player, new LinkOption[0])) throw NOT_FOUND.create();
        try (InputStream in = Files.newInputStream(player, new OpenOption[0]);){
            CompoundTag playerDat = NbtIo.readCompressed((InputStream)in, (NbtAccounter)NbtAccounter.unlimitedHeap());
            if (!playerDat.contains("neoforge:attachments", 10)) throw NOT_FOUND.create();
            CompoundTag attachmentData = playerDat.getCompound("neoforge:attachments");
            CompoundTag bagData = attachmentData.getCompound(PEAttachmentTypes.ALCHEMICAL_BAGS.getId().toString());
            RegistryOps serializationContext = server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            DataResult result = AlchBagImpl.AlchemicalBagAttachment.CODEC.parse((DynamicOps)serializationContext, (Object)bagData);
            if (!result.isSuccess()) throw NOT_FOUND.create();
            ItemStackHandler itemStackHandler = ((AlchBagImpl.AlchemicalBagAttachment)result.getOrThrow()).getBag(color);
            return itemStackHandler;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw NOT_FOUND.create();
    }
}

